/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.vodafone;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * 3GC[̃AvP[V񋟂܂B
 * 
 * @author V _
 */
final class ApplicationImpl implements Application {

	/**
	 * AvP[V̎ނw肵ẴNX\z܂B
	 * 
	 * @param type AvP[V̎
	 */
	public ApplicationImpl(final ApplicationType type) {
		this.type = type;
	}

	/**
	 * SẴtB[hw肵ẴNX\z܂B
	 * 
	 * @param type AvP[V̎
	 * @param name AvP[V
	 * @param version AvP[Ṽo[W
	 */
	public ApplicationImpl(final ApplicationType type, final String name, final Float version) {
		this.type = type;
		this.name = name;
		this.version = version;
	}

	/**
	 * AvP[V̎ނێ܂B
	 */
	private ApplicationType type;

	/*
	 * @see jp.sourceforge.livez.vodafone.Application#getType()
	 */
	public ApplicationType getType() {
		return type;
	}

	/**
	 * AvP[V̖Oێ܂B
	 */
	private String name = null;

	/*
	 * @see jp.sourceforge.livez.vodafone.Application#getName()
	 */
	public String getName() {
		return name;
	}

	/**
	 * AvP[Ṽo[Wێ܂B
	 */
	private Float version = null;

	/*
	 * @see jp.sourceforge.livez.vodafone.Application#getVersion()
	 */
	public Float getVersion() {
		return version;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
