/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.vodafone;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import jp.sourceforge.livez.Screen;

/**
 * Screen ̎NXłB
 * 
 * @author V _
 */
final class ScreenImpl implements Screen {

	private static final long serialVersionUID = 1L;

	/**
	 * RXgN^łB
	 * 
	 * @param r {[_tH[NGXg
	 */
	public ScreenImpl(final VodafoneRequest r) {
		if (r.getType().getCategoryType() == VodafoneCategoryType.THREE_GC) {
			this.width = r.getDisplayWidth();
			this.height = r.getDisplayHeight();
		} else {
			this.width = 0;
			this.height = 0;
		}

		this.qvga = width >= 240/* && height >= 320*/;
		this.monochrome = r.isMonochrome();
		this.color = r.getColor();
	}

	/**
	 * ێ܂B
	 */
	private int width;

	/*
	 * @see jp.sourceforge.livez.Screen#getWidth()
	 */
	public int getWidth() {
		return width;
	}

	/**
	 * ێ܂B
	 */
	private int height;

	/*
	 * @see jp.sourceforge.livez.Screen#getHeight()
	 */
	public int getHeight() {
		return height;
	}

	/**
	 * mNʂǂێ܂B
	 */
	private boolean monochrome;

	/*
	 * @see jp.sourceforge.livez.Screen#isMonochrome()
	 */
	public boolean isMonochrome() {
		return monochrome;
	}

	/**
	 * F/Kێ܂B
	 */
	private int color;

	/*
	 * @see jp.sourceforge.livez.Screen#getColor()
	 */
	public int getColor() {
		return color;
	}

	private boolean qvga;

	/*
	 * @see jp.sourceforge.livez.Screen#isQVGA()
	 */
	public boolean isQVGA() {
		return qvga;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
