/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.vodafone;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import jp.sourceforge.livez.IllegalUserIdException;

/**
 * UID NXłB
 * 
 * @author V _
 */
final class UIDImpl implements UID {

	private static final long serialVersionUID = 1L;

	/**
	 * w肳ꂽ񂩂NX\z܂B
	 * 
	 * @param uid UID \
	 * @throws IllegalUserIdException UID sȏꍇ
	 */
	public UIDImpl(final String uid) throws IllegalUserIdException {
		parse(uid);
	}

	/**
	 * w肳ꂽHTTPNGXg񂩂NX\z܂B
	 * 
	 * @param request HTTPNGXg
	 * @throws IllegalUserIdException UID sȏꍇ
	 */
	public UIDImpl(final HttpServletRequest request) throws IllegalUserIdException {
		parse(request.getHeader("x-jphone-uid"));
	}

	private void parse(final String uid) throws IllegalUserIdException {
		this.value = uid;

		if (uid == null || uid.equals("NULL")) {
			this.disabled = true;
			this.cType = false;
			this.region = 0;
			this.userId = null;
		} else if(uid.matches("^[123456789][0-9a-zA-Z]{15}$")) {
			this.disabled = false;
			this.cType = true;
			this.region = uid.charAt(0);
			this.userId = uid.substring(1);
		} else if(uid.matches("^[abcdefghi][0-9a-zA-Z]{15}$")) {
			this.disabled = false;
			this.cType = false;
			this.region = uid.charAt(0);
			this.userId = uid.substring(1);
		} else
			throw new IllegalUserIdException();
	}

	/**
	 * UID ̐lێ܂B
	 */
	private String value;

	/*
	 * @see jp.sourceforge.livez.vodafone.UID#getValue()
	 */
	public String getValue() {
		return value;
	}

	/**
	 * UID ʒm󋵂ێ܂B
	 */
	private boolean disabled;

	/*
	 * @see jp.sourceforge.livez.vodafone.UID#isDisabled()
	 */
	public boolean isDisabled() {
		return disabled;
	}

	/**
	 * UID  C^ ǂێ܂B
	 */
	private boolean cType;

	/*
	 * @see jp.sourceforge.livez.vodafone.UID#isCtype()
	 */
	public boolean isCtype() {
		return cType;
	}

	/**
	 * UID̐擪1oCg̃GAR[hێ܂B
	 */
	private char region;

	/*
	 * @see jp.sourceforge.livez.vodafone.UID#getRegion()
	 */
	public char getRegion() {
		return region;
	}

	/**
	 * [UIDێ܂B
	 */
	private String userId;

	/*
	 * @see jp.sourceforge.livez.vodafone.UID#getUserId()
	 */
	public String getUserId() {
		return userId;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
