/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.vodafone;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * Vappli NXłB
 * 
 * @author V _
 */
final class VappliImpl implements Vappli {

	private static final long serialVersionUID = 1L;

	/**
	 * MIDP o[W CLDC o[Ww肵ẴNX\z܂B
	 * 
	 * @param midp MIDP o[W
	 * @param cldc CLDC o[W
	 */
	public VappliImpl(final float midp, final float cldc) {
		this.midpVersion = midp;
		this.cldcVersion = cldc;
	}

	/**
	 * MIDP o[W CLDC o[Ww肵ẴNX\z܂B
	 * 
	 * @param midp MIDP o[W
	 * @param cldc CLDC o[W
	 * @param jscl JSCL o[W
	 * @param vscl VSCL o[W
	 */
	public VappliImpl(final float midp, final float cldc, final String jscl, final String vscl) {
		this.midpVersion = midp;
		this.cldcVersion = cldc;
		this.jsclVersion = jscl;
		this.vsclVersion = vscl;
	}

	/**
	 * MIDP Ήo[Wێ܂B
	 */
	private float midpVersion;

	/*
	 * @see jp.sourceforge.livez.vodafone.Vappli#getMidpVersion()
	 */
	public float getMidpVersion() {
		return midpVersion;
	}

	/**
	 * CLDC Ήo[Wێ܂B
	 */
	private float cldcVersion;

	/*
	 * @see jp.sourceforge.livez.vodafone.Vappli#getCldcVersion()
	 */
	public float getCldcVersion() {
		return cldcVersion;
	}

	/**
	 * JSCL Ήo[Wێ܂B
	 */
	private String jsclVersion = null;

	/*
	 * @see jp.sourceforge.livez.vodafone.Vappli#getJsclVersion()
	 */
	public String getJsclVersion() {
		return jsclVersion;
	}

	/**
	 * VSCL Ήo[Wێ܂B
	 */
	private String vsclVersion = null;

	/*
	 * @see jp.sourceforge.livez.vodafone.Vappli#getVsclVersion()
	 */
	public String getVsclVersion() {
		return vsclVersion;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
