/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.vodafone;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * VodafoneBrowser ̎NXłB
 * 
 * @author V _
 */
final class VodafoneBrowserImpl implements VodafoneBrowser {

	private static final long serialVersionUID = 1L;

	/**
	 * RXgN^łB
	 */
	public VodafoneBrowserImpl(final VodafoneRequest r) {
		this.width = r.getDisplayWidth();
		this.height = r.getDisplayHeight();

		switch (r.getType().getCategoryType()) {
			case C:
				this.cacheSize = 6 *1024;
				if (r.getType() == VodafoneType.C2) {
					this.mmlVersion = new Float("2.0");
					this.htmlVersion = new Float("2.0");
				} else {
					this.mmlVersion = new Float("3.0");
					this.htmlVersion = new Float("3.0");
				}
				break;

			case P:
				switch (r.getType()) {
					case P4_1:
					case P4_2:
						this.cacheSize = 12 * 1024;
						break;
					default:
						this.cacheSize = 30 * 1024;
				}

				this.mmlVersion = new Float("3.0");
				this.htmlVersion = new Float("4.0");
				break;

			case W:
				this.htmlVersion = new Float("4.0");
				this.xhtmlVersion = new Float("1.0");
				this.cacheSize = 200 * 1024;
				break;

			case THREE_GC:
				this.xhtmlVersion = new Float("1.0");
				this.cacheSize = 300 * 1024;
		}
	}

	/**
	 * uEU̕ێ܂B
	 */
	private int width = 0;

	/*
	 * @see jp.sourceforge.livez.Browser#getWidth()
	 */
	public int getWidth() {
		return width;
	}

	/**
	 * uEU̍ێ܂B
	 */
	private int height = 0;

	/*
	 * @see jp.sourceforge.livez.Browser#getHeight()
	 */
	public int getHeight() {
		return height;
	}

	/*
	 * @see jp.sourceforge.livez.Browser#getColumn()
	 */
	public int getColumn() {
		return 0;
	}

	/*
	 * @see jp.sourceforge.livez.Browser#getRow()
	 */
	public int getRow() {
		return 0;
	}

	/**
	 * LbVTCYێ܂B<p>
	 */
	private int cacheSize = 0;

	/*
	 * @see jp.sourceforge.livez.Browser#getCacheSize()
	 */
	public int getCacheSize() {
		return cacheSize;
	}

	/**
	 * MML Ήo[Wێ܂B
	 */
	private Float mmlVersion = null;

	/*
	 * @see jp.sourceforge.livez.vodafone.VodafoneBrowser#getMmlVersion()
	 */
	public Float getMmlVersion() {
		return mmlVersion;
	}

	/**
	 * HTML Ήo[Wێ܂B
	 */
	private Float htmlVersion = null;

	/*
	 * @see jp.sourceforge.livez.vodafone.VodafoneBrowser#getHtmlVersion()
	 */
	public Float getHtmlVersion() {
		return htmlVersion;
	}

	/**
	 * XHTML Ήo[Wێ܂B
	 */
	private Float xhtmlVersion = null;

	/*
	 * @see jp.sourceforge.livez.Browser#getXhtmlVersion()
	 */
	public Float getXhtmlVersion() {
		return xhtmlVersion;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
