/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.vodafone;

import javax.servlet.http.HttpServletRequest;

import org.springframework.dao.DataAccessException;

import jp.sourceforge.livez.IllegalRequestException;
import jp.sourceforge.livez.MobilePhoneGenerator;
import jp.sourceforge.livez.dao.VodafoneDAO;

/**
 * {[_tH[𐶐gђ[WFl[^NXłB
 * 
 * @author V _
 */
public final class VodafoneGenerator extends MobilePhoneGenerator<VodafoneRequest, Vodafone> {

	public static final String BEAN_ID = "vodafoneGenerator";

	/**
	 * VodafoneDAO ێ܂B
	 */
	private VodafoneDAO vodafoneDAO = null;

	/**
	 * VodafoneDAO ݒ肵܂B
	 * 
	 * @param vodafoneDAO VodafoneDAO
	 */
	public void setVodafoneDAO(final VodafoneDAO vodafoneDAO) {
		this.vodafoneDAO = vodafoneDAO;
	}

	/**
	 * ftHgRXgN^łB
	 */
	public VodafoneGenerator() {}

	/**
	 * {[_tH[NGXg񂩂{[_tH[𐶐ĕԂ܂B
	 * 
	 * @param r {[_tH[NGXg
	 * @return {[_tH[
	 * @throws NullPointerException {[_tH[NGXg <code>null</code> ̏ꍇ
	 * @throws DataAccessException VodafoneDAO ̑ŗOꍇ
	 */
	@Override
	public Vodafone create(final VodafoneRequest r) throws NullPointerException, DataAccessException {
		final VodafoneImpl result = new VodafoneImpl();

		if (vodafoneDAO != null) {
			jp.sourceforge.livez.dao.Vodafone v = vodafoneDAO.load(r.getName());
			if (v != null)
				result.setup(v);
		}

		result.setup(r);
		return result;
	}

	/**
	 * HTTP NGXg񂩂{[_tH[𐶐ĕԂ܂B
	 * 
	 * @param request HTTPNGXg
	 * @return {[_tH[
	 * @throws NullPointerException HTTPNGXg <code>null</code> ̏ꍇ
	 * @throws IllegalRequestException HTTPNGXg񂪕sȏꍇ
	 * @throws DataAccessException VodafoneDAO ̑ŗOꍇ
	 */
	@Override
	public Vodafone create(HttpServletRequest request) throws NullPointerException, IllegalRequestException, DataAccessException {
		return create(new VodafoneRequestImpl(request));
	}

}
