/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.vodafone;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import jp.sourceforge.livez.CarrierType;
import jp.sourceforge.livez.Screen;
import jp.sourceforge.livez.ServiceType;
import jp.sourceforge.livez.images.ImageType;

/**
 * Vodafone NXłB
 * 
 * @author V _
 */
final class VodafoneImpl implements Vodafone {

	private static final long serialVersionUID = 1L;

	/**
	 * ftHgRXgN^łB
	 */
	public VodafoneImpl() {
		this.imageTypes.add(ImageType.PNG);
	}

	void setup(final jp.sourceforge.livez.dao.Vodafone v) {
		// ̌Qݒ肵܂
		this.name			= v.getName();
		this.productName	= v.getProductName();
	}

	void setup(final VodafoneRequest r) {
		final VodafoneUserAgent ua = r.getUserAgent();

		// ̌Qݒ肵܂
		this.id = r.getId();
		this.name = r.getName();

		if (this.productName == null)
			this.productName = r.getName();

		this.seriesName = r.getSeriesName();
		this.vendorId = r.getVendorId();

		if (r.getType() != VodafoneType.UNKNOWN) {
			// ʏ\z܂
			this.screen = new ScreenImpl(r);

			// uEU\z܂
			this.browser = new VodafoneBrowserImpl(r);
		}
	
		// VAvݒ肵܂
		this.appli = ua.getVappli();

		// TEh񂪑݂ꍇ͍\z܂
		if (r.getSmd() > 0 || r.getSmaf() != null)
			this.sound = new VodafoneSoundImpl(r);

		// NGXgݒ肵܂
		this.type			= r.getType();
		this.application	= ua.getApplication();
		this.serialNumber	= ua.getSerialNumber();
		this.uid			= r.getUID();

		if (r.getType() != VodafoneType.C2)
			this.imageTypes.add(ImageType.JPEG);
		if (r.getType() != VodafoneType.UNKNOWN
			|| r.getType().getCategoryType() != VodafoneCategoryType.THREE_GC)
			this.imageTypes.add(ImageType.GIF_8BIT);
	}

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getServiceType()
	 */
	public ServiceType getServiceType() {
		return ServiceType.VODAFONE_LIVE;
	}

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getCarrierType()
	 */
	public CarrierType getCarrierType() {
		return CarrierType.VODAFONE;
	}

	/**
	 * [ID ێ܂B
	 */
	private String id = null;

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getId()
	 */
	public String getId() {
		return id;
	}

	/**
	 * @햼ێ܂B
	 */
	private String name = null;

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getName()
	 */
	public String getName() {
		return name;
	}

	/**
	 * iێ܂B
	 */
	private String productName = null;

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getProductName()
	 */
	public String getProductName() {
		return productName;
	}

	/**
	 * V[Yێ܂B
	 */
	private String seriesName = null;

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getSeriesName()
	 */
	public String getSeriesName() {
		return seriesName;
	}

	/**
	 * x_[IDێ܂B
	 */
	private String vendorId = null;

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getVendorId()
	 */
	public String getVendorId() {
		return vendorId;
	}

	private ScreenImpl screen = null;

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getScreen()
	 */
	public Screen getScreen() {
		return screen;
	}

	private VodafoneBrowserImpl browser = null;

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getBrowser()
	 */
	public VodafoneBrowser getBrowser() {
		return browser;
	}

	/**
	 * VAvsێ܂B
	 */
	private Vappli appli = null;

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getAppli()
	 */
	public Vappli getAppli() {
		return appli;
	}

	private VodafoneSoundImpl sound = null;

	/*
	 * @see jp.sourceforge.livez.vodafone.Vodafone#getSound()
	 */
	public VodafoneSound getSound() {
		return sound;
	}

	/**
	 * [̌^ێ܂B
	 */
	private VodafoneType type = null;

	/*
	 * @see jp.sourceforge.livez.vodafone.Vodafone#getType()
	 */
	public VodafoneType getType() {
		return type;
	}

	/**
	 * ANZXAvP[Vێ܂B
	 */
	private Application application = null;

	/*
	 * @see jp.sourceforge.livez.vodafone.Vodafone#getApplication()
	 */
	public Application getApplication() {
		return application;
	}

	/**
	 * [̐ԍێ܂B
	 */
	private String serialNumber = null;

	/*
	 * @see jp.sourceforge.livez.vodafone.Vodafone#getSerialNumber()
	 */
	public String getSerialNumber() {
		return serialNumber;
	}

	/**
	 * UID ێ܂B
	 */
	private UID uid = null;

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getUserId()
	 */
	public UID getUserId() {
		return uid;
	}

	private List<ImageType> imageTypes = new ArrayList<ImageType>(4);

	/*
	 * @see jp.sourceforge.livez.MobilePhone#getEnableImageTypes()
	 */
	public List<ImageType> getEnableImageTypes() {
		return imageTypes;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
