/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.vodafone;

import jp.sourceforge.livez.MobilePhoneRequest;

/**
 * {[_tH[NGXg(MS-Profile)̃C^[tF[XłB
 * 
 * @author V _
 */
public interface VodafoneRequest extends MobilePhoneRequest<VodafoneUserAgent> {

	/**
	 * {[_tH[ HTTP [UG[WFgԂ܂B
	 * 
	 * @return {[_tHHTTP[UG[WFg
	 */
	public VodafoneUserAgent getUserAgent();

	/**
	 * [̏ڍׂȌ^Ԃ܂B
	 * 
	 * @return [^
	 */
	public VodafoneType getType();

	/**
	 * [ID(x-jphone-msname ̒l)Ԃ܂B
	 * 
	 * @return [ID
	 */
	public String getId();

	/**
	 * [ID(x-jphone-msname̒l)}Ci[o[Wԍ揜@햼Ԃ܂B
	 * 
	 * @return @햼
	 */
	public String getName();

	/**
	 * V[YԂ܂B
	 * 
	 * @return V[Y
	 */
	public String getSeriesName();

	/**
	 * x_[IDԂ܂B
	 * 
	 * @return x_[ID
	 */
	public String getVendorId();

	/**
	 * mNʂǂԂ܂B
	 * 
	 * @return mNʂǂ
	 */
	public boolean isMonochrome();

	/**
	 * (x-jphone-color) F܂͊KԂ܂B
	 * 
	 * @return F܂͊K
	 */
	public int getColor();

	/**
	 * (x-jphone-display) uEU̕\\ȕԂ܂B
	 * 3GC [ł LCD ̕Ԃ܂B
	 * 
	 * @return uEU̕\\ȕB3GC[ł LCD ̕
	 */
	public int getDisplayWidth();

	/**
	 * (x-jphone-display) uEU̕\\ȍԂ܂B
	 * 3GC [ł LCD ̕Ԃ܂B
	 * 
	 * @return uEU̕\\ȍB3GC[ł LCD ̍
	 */
	public int getDisplayHeight();

	/**
	 * (x-jphone-geocode) C^(C2)yP^[̏ꍇ͈ʒuԂ܂B
	 * ȊȌꍇ <code>null</code> Ԃ܂B<p>
	 * l͊ɕĂ܂B
	 * 
	 * @return ʒu
	 */
	public String getGeoCode();

	/**
	 * (x-jphone-java) C4^[̏ꍇ(pPbgΉ@̏ꍇ)ɁAΉ Java (JSCL) o[WԂ܂B
	 * ȊȌꍇ <code>null</code> Ԃ܂B
	 * 
	 * @return Java (JSCL) o[W
	 */
	public String getJsclVersion();

	/**
	 * (x-jphone-region) W^y3GC^[̏ꍇA[U̗pn(/O)Ԃ܂B
	 * sȏꍇ <code>null</code> Ԃ܂B
	 * 
	 * @return [U̗pn
	 */
	public String getRegion();

	/**
	 * (x-jphone-smaf) SMAF ^CvԂ܂B
	 * s(C2^[ꕔ3GC^[)ꍇ <code>null</code> Ԃ܂B
	 * 
	 * @return SMAF ^Cv
	 */
	public VodafoneSmaf getSmaf();

	/**
	 * (x-jphone-sound) t\ SMD ̍őa(SkyfBa)Ԃ܂B
	 * SMD ɑΉĂȂꍇ(3GC^[̏ꍇ) 0 ȉ̒lԂ܂B
	 * 
	 * @return t\ SMD ̍őaBΉ̏ꍇ 0 ȉ̒l
	 */
	public int getSmd();


	/**
	 * (x-jphone-notifyid) ۋ̈Ӑ\ID(p10)Ԃ܂B
	 * 3GC[ŁA]ʉۋy Separate Delivery 𗘗pꍇ̑BmF񑗏ôݒlԂ܂B
	 * ȊȌꍇ <code>null</code> Ԃ܂B
	 * 
	 * @return ۋ̈Ӑ\ID
	 */
	public String getNotifyId();

	/**
	 * (x-jphone-regidterd) 񗿉ۋT[rXɂėL̗pɓӂǂԂ܂B
	 * 3GC[ɂRecEL[ۋ̏ꍇA <code>false</code> Ԃ܂B
	 * 
	 * @return L̗pɓӂǂ
	 */
	public boolean getRegisterd();

	/**
	 * UID Ԃ܂B
	 * 
	 * @return UID 
	 */
	public UID getUID();

}
