/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.vodafone;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.context.WebApplicationContext;

import jp.sourceforge.livez.IllegalRequestException;
import jp.sourceforge.livez.Service;
import jp.sourceforge.livez.util.SpringUtils;

/**
 * {[_tHT[rX؃NXłB
 * 
 * @author V _
 */
public final class VodafoneService implements Service<VodafoneRequest, VodafoneGenerator> {

	/**
	 * ftHgRXgN^łB
	 */
	public VodafoneService() {}

	/**
	 * HTTP NGXg͂{[_tH[NGXgԂ܂B
	 * 
	 * @param request HTTP NGXg
	 * @return {[_tH[NGXg
	 * @throws NullPointerException HTTPNGXg <code>null</code> ̏ꍇ
	 * @throws IllegalRequestException HTTPNGXg񂪕sȏꍇ
	 */
	public VodafoneRequest getMobilePhoneRequest(final HttpServletRequest request) throws NullPointerException, IllegalRequestException {
		return new VodafoneRequestImpl(request);
	}

	/**
	 * {[_tH[WFl[^Ԃ܂B
	 * 
	 * @param context Spring Framework  WebApplicationContext
	 * @return {[_tH[WFl[^
	 */
	public VodafoneGenerator getMobilePhoneGenerator(final WebApplicationContext context) {
		return (VodafoneGenerator) SpringUtils.getRequiredBean(context, VodafoneGenerator.BEAN_ID);
	}

}
