/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.vodafone;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.math.NumberUtils;

/**
 * SAMF Ɋւ{[_zdl̎NXłB
 * 
 * @author V _
 */
final class VodafoneSmafImpl implements VodafoneSmaf {

	private static final long serialVersionUID = 1L;

	/**
	 * RXgN^łB
	 * 
	 * @throws NullPointerException p[^ null w肵ꍇ
	 * @throws IllegalArgumentException p[^̒lsȏꍇ
	 */
	protected VodafoneSmafImpl(final String smaf) throws NullPointerException, IllegalArgumentException {
		if (smaf == null)
			throw new NullPointerException();
		if (!smaf.matches("^[0-9]+(/pcm(/grf(/rs){0,1}){0,1}){0,1}$"))
			throw new IllegalArgumentException();

		final String[] s = smaf.split("/");
		this.melody = NumberUtils.toInt(s[0]);

		switch (s.length) {
			default:
			case 4:	// rs
				this.exKaraoke = "rs".equals(s[3]);
			case 3:	// grf
				this.karaoke = "grf".equals(s[2]);
			case 2:
				if ("pcm".equals(s[1])) {
					this.adpcm = true;
					this.pcm = (this.melody >= 40);
				}
			case 1:
			case 0:
		}
	}

	/**
	 * aێ܂B
	 */
	private int melody = 0;

	/*
	 * @see jp.sourceforge.livez.vodafone.VodafoneSmaf#getMelody()
	 */
	public int getMelody() {
		return melody;
	}

	/**
	 * ADPCM Ή󋵂ێ܂B
	 */
	private boolean adpcm = false;

	/*
	 * @see jp.sourceforge.livez.vodafone.VodafoneSmaf#isAdpcm()
	 */
	public boolean isAdpcm() {
		return adpcm;
	}

	/**
	 * PCM Ή󋵂ێ܂B
	 */
	private boolean pcm = false;

	/*
	 * @see jp.sourceforge.livez.vodafone.VodafoneSmaf#isPcm()
	 */
	public boolean isPcm() {
		return pcm;
	}

	/**
	 * 摜/eLXg(JIP(VN))Ή󋵂ێ܂B
	 */
	private boolean karaoke = false;

	/*
	 * @see jp.sourceforge.livez.vodafone.VodafoneSmaf#isKaraoke()
	 */
	public boolean isKaraoke() {
		return karaoke;
	}

	/**
	 * JIP(VN)gΉ󋵂ێ܂B
	 */
	private boolean exKaraoke = false;

	/*
	 * @see jp.sourceforge.livez.vodafone.VodafoneSmaf#isExKaraoke()
	 */
	public boolean isExKaraoke() {
		return exKaraoke;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
