/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.vodafone;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * VodafoneSound NXłB<p>
 * 
 * @author V _
 */
final class VodafoneSoundImpl implements VodafoneSound {

	private static final long serialVersionUID = 1L;

	/**
	 * RXgN^łB
	 * 
	 * @param r
	 */
	public VodafoneSoundImpl(final VodafoneRequest r) {
		this.smd	= r.getSmd();
		this.smaf	= r.getSmaf();
	}

	private int smd;

	/*
	 * @see jp.sourceforge.livez.vodafone.VodafoneSound#getSmd()
	 */
	public int getSmd() {
		return smd;
	}

	private VodafoneSmaf smaf;

	/*
	 * @see jp.sourceforge.livez.vodafone.VodafoneSound#getSmaf()
	 */
	public VodafoneSmaf getSmaf() {
		return smaf;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
