/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.vodafone;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.math.NumberUtils;

import jp.sourceforge.livez.IllegalUserAgentException;
import jp.sourceforge.livez.UserAgentNotFoundException;

/**
 * VodafoneLiveUserAgent NXłB
 * 
 * @author V _
 */
final class VodafoneUserAgentImpl implements VodafoneUserAgent {

	static final String JPHONE_MSNAME = "J-[A-Z]+[0-9]+[A-Z]*";
	static final String VODAFONE_MSNAME = "V[0-9]{3}[A-Z]+[0-9a-z]*";

	private static final String MSNAME 		= "(" + JPHONE_MSNAME + "|" + VODAFONE_MSNAME + "|V-XX111){1}(_[a-z]+)?";
	private static final String SERIAL_NUMBER	= "SN[a-zA-Z0-9]{11,15}";
	private static final String MSVENDOR		= "[A-Z]+/.+";
	private static final String MIDP			= "Profile/MIDP-[0-9]\\.[0-9]";
	private static final String CLDC			= "Configuration/CLDC-[0-9]\\.[0-9]";
	private static final String JSCL			= "Ext-Profile/JSCL-[0-9]\\.[0-9]\\.[0-9]";

	private static final String USERAGENT_JPHONE =
		"^J-PHONE/[23456789]\\.[0-9]/" + MSNAME +
			"(/" + SERIAL_NUMBER + ")?" +
			"( " + MSVENDOR + ")?" +
			"( " + MIDP + ")?" +
			"( " + CLDC + ")?" +
			"( " + JSCL + ")?" +
		"$";

	private static final String UNTRUSTED		= "UNTRUSTED/1.0";
	private static final String USERAGENT_UNTRUSTED = "^" + UNTRUSTED + "$";

	private static final String APPLICATION	= "(Browser|Java|SVG|Flash)+/.+/.+";
	private static final String JSCL2			= "Ext-J-Profile/JSCL-[0-9]\\.[0-9]\\.[0-9]";
	private static final String VSCL			= "Ext-V-Profile/VSCL-[0-9]\\.[0-9]\\.[0-9]";

	private static final String USERAGENT_VODAFONE =
		"^Vodafone/1\\.[0-9]/" + MSNAME + "/.+(/" + SERIAL_NUMBER + ")?.*" +
			"( " + APPLICATION + ")?" +
			"( " + MIDP + ")?" +
			"( " + CLDC + ")?" +
			"( (" + JSCL + '|' + JSCL2 + "){1})?" +
			"( " + VSCL + ")?" +
			"(( |/){1}" + UNTRUSTED + ")?" +
		"$";

	private static final String MOTOROLA_PREFIX = "MOT-";

	private static final String USERAGENT_MOTOROLA =
		"^" + MOTOROLA_PREFIX + ".+/[a-zA-Z0-9]+\\.[a-zA-Z0-9]+\\.[a-zA-Z0-9]+" +
			"( MIB/[0-9]\\.[0-9]\\.[0-9])?" +
			"( " + MIDP + ")?" +
			"( " + CLDC + ")?" +
		"$";

	/**
	 * w肳ꂽHTTPNGXg񂩂NX\z܂B
	 * 
	 * @param request HTTPNGXg
	 * @throws UserAgentNotFoundException [U[G[WFg null ̏ꍇ
	 * @throws IllegalUserAgentException [UG[WFǧ`sȏꍇ
	 */
	public VodafoneUserAgentImpl(final HttpServletRequest request) throws UserAgentNotFoundException, IllegalUserAgentException {
		this(request.getHeader(HTTP_HEADER_KEY));
	}

	/**
	 * w肳ꂽ񂩂NX\z܂B
	 * 
	 * @param ua HTTP [U[G[WFg\
	 * @throws UserAgentNotFoundException [U[G[WFg null ̏ꍇ
	 * @throws IllegalUserAgentException [UG[WFǧ`sȏꍇ
	 */
	public VodafoneUserAgentImpl(final String ua) throws UserAgentNotFoundException, IllegalUserAgentException {
		if (ua == null)
			throw new UserAgentNotFoundException();

		this.value = ua;

		// O܂
		String[] s;
		s = ua.split("/");

		// [ID[ݒ肵܂
		if (value.matches(USERAGENT_JPHONE)) {
			this.id = s[2];
			this.generationVersion = NumberUtils.toFloat(s[1]);
		} else if (value.matches(USERAGENT_UNTRUSTED)) {
			this.generationVersion = NumberUtils.toFloat("1.0");
			this.application = new ApplicationImpl(ApplicationType.JAVA);
			this.vappli = new VappliImpl((float)2.0, (float)1.1);
			return;		// ȏ㏈܂
		} else if (value.matches(USERAGENT_VODAFONE)) {
			this.id = s[2];
			this.generationVersion = NumberUtils.toFloat(s[1]);
		} else if (value.matches(USERAGENT_MOTOROLA)) {
			this.id = s[0].substring(MOTOROLA_PREFIX.length());
			this.generationVersion = (float) 1.0;
		} else
			throw new IllegalUserAgentException(ua);

		// VAԍݒ肵܂
		for (int i = 3; i < s.length; i++) {
			if (s[i].matches(SERIAL_NUMBER))
				this.serialNumber = s[i].substring(2);
		}

		// g̉
		// 㔼ApPbgΉ@̊gvpeBݒ肵܂
		Float midp = null;
		Float cldc = null;
		String jscl = null;
		String vscl = null;
		boolean untrusted = false;

		s = ua.split(" ");
		for (int i = 1; i < s.length; i++) {
			// VAv
			if (s[i].matches(MIDP)) {
				midp = NumberUtils.toFloat(s[i].substring(s[i].lastIndexOf('-') + 1));
			} else if (s[i].matches(CLDC)) {
				cldc = NumberUtils.toFloat(s[i].substring(s[i].lastIndexOf('-') + 1));
			} else if (s[i].matches(JSCL) || s[i].matches(JSCL2)) {
				jscl = s[i].substring(s[i].lastIndexOf('-') + 1);
			} else if (s[i].matches(VSCL)) {
				vscl = s[i].substring(s[i].lastIndexOf('-') + 1);

			// 3GC[̃AvP[V
			} else if (s[i].startsWith("Browser/")) {
				final String[] strings = s[i].split("/");
				this.application = new ApplicationImpl(ApplicationType.BROWSER, strings[1], NumberUtils.toFloat(strings[2]));
			} else if (s[i].startsWith("Java/")) {
				final String[] strings = s[i].split("/");
				this.application = new ApplicationImpl(ApplicationType.JAVA, strings[1], NumberUtils.toFloat(strings[2]));
			} else if (s[i].startsWith("SVG/")) {
				final String[] strings = s[i].split("/");
				this.application = new ApplicationImpl(ApplicationType.SVG, strings[1], NumberUtils.toFloat(strings[2]));
			} else if (s[i].startsWith("Flash/")) {
				final String[] strings = s[i].split("/");
				this.application = new ApplicationImpl(ApplicationType.FLASH, strings[1], NumberUtils.toFloat(strings[2]));
			}

			// UNTRUSTED 
			if (s[i].indexOf(UNTRUSTED) != -1)
				untrusted = true;
		}

		// UNTRUSTED ̏ꍇ MIDP-2.0  Java AvŃANZXȂ̂Őݒ
		if (untrusted) {
			if (this.application == null)
				this.application = new ApplicationImpl(ApplicationType.JAVA);

			if (midp == null)
				midp = (float) 2.0;
			if (cldc == null)
				cldc = (float) 1.1;
		}

		if (midp != null || cldc != null || jscl != null || vscl != null)
			this.vappli = new VappliImpl(midp, cldc, jscl, vscl);
	}

	/**
	 * [UG[WFgێ܂B
	 */
	private String value = null;

	/*
	 * @see jp.sourceforge.livez.UserAgent#getValue()
	 */
	public String getValue() {
		return value;
	}

	/**
	 * [IDێ܂B
	 */
	private String id = null;

	/*
	 * @see jp.sourceforge.livez.UserAgent#getId()
	 */
	public String getId() {
		return id;
	}

	/**
	 * ̃o[Wێ܂B
	 */
	private float generationVersion;

	/*
	 * @see jp.sourceforge.livez.vodafone.VodafoneUserAgent#getGenerationVersion()
	 */
	public float getGenerationVersion() {
		return generationVersion;
	}

	/**
	 * VAԍێ܂B
	 */
	private String serialNumber = null;

	/*
	 * @see jp.sourceforge.livez.vodafone.VodafoneUserAgent#getSerialNumber()
	 */
	public String getSerialNumber() {
		return serialNumber;
	}

	/**
	 * 3GC[ł̃AvP[Vێ܂B
	 */
	private ApplicationImpl application = null;

	/*
	 * @see jp.sourceforge.livez.vodafone.VodafoneUserAgent#getApplication()
	 */
	public Application getApplication() {
		return application;
	}

	/**
	 * VAvsێ܂B
	 */
	private VappliImpl vappli = null;

	/*
	 * @see jp.sourceforge.livez.vodafone.VodafoneUserAgent#getVappli()
	 */
	public Vappli getVappli() {
		return vappli;
	}

	@Override
	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	@Override
	public boolean equals(final Object obj) {
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
