/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.imode;

import junit.framework.TestCase;

/**
 * 
 * @author V _
 */
public final class AccessTypeTest extends TestCase {

	public void testGetAccessType() {
		assertTrue(AccessType.getAccessType("TB") == AccessType.BROWSER_OR_ADF);
		assertTrue(AccessType.getAccessType("TC") == AccessType.BROWSER_NONE_IMAGE);
		assertTrue(AccessType.getAccessType("TD") == AccessType.JAR);
		assertTrue(AccessType.getAccessType("TJ") == AccessType.I_APPLI);
		assertTrue(AccessType.getAccessType("TE") == AccessType.FELICA);

		try {
			AccessType.getAccessType("XX");
		} catch (IllegalArgumentException e) {
			assertNotNull(e.getMessage());
		}
	}

}
