/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.imode;

import junit.framework.TestCase;

/**
 * 
 * @author V _
 */
public final class ImodeUserAgentImplTest extends TestCase {

	public void test() throws Exception {
		ImodeUserAgent ua;

		// 501i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D501i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "D501i");
		assertEquals(ua.getName(), "D501i");
		assertEquals(ua.getVendorId(), "D");
		assertEquals(ua.getSeriesName(), "501i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F501i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "F501i");
		assertEquals(ua.getName(), "F501i");
		assertEquals(ua.getVendorId(), "F");
		assertEquals(ua.getSeriesName(), "501i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N501i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "N501i");
		assertEquals(ua.getName(), "N501i");
		assertEquals(ua.getVendorId(), "N");
		assertEquals(ua.getSeriesName(), "501i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P501i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "P501i");
		assertEquals(ua.getName(), "P501i");
		assertEquals(ua.getVendorId(), "P");
		assertEquals(ua.getSeriesName(), "501i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		////////////////////////////////////////////////////////////
		// i[h HTML 2.0 (LbV)

		// 502i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D502i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "D502i");
		assertEquals(ua.getName(), "D502i");
		assertEquals(ua.getVendorId(), "D");
		assertEquals(ua.getSeriesName(), "502i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D502i/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "D502i");
		assertEquals(ua.getName(), "D502i");
		assertEquals(ua.getVendorId(), "D");
		assertEquals(ua.getSeriesName(), "502i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F502i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "F502i");
		assertEquals(ua.getName(), "F502i");
		assertEquals(ua.getVendorId(), "F");
		assertEquals(ua.getSeriesName(), "502i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F502i/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "F502i");
		assertEquals(ua.getName(), "F502i");
		assertEquals(ua.getVendorId(), "F");
		assertEquals(ua.getSeriesName(), "502i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N502i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "N502i");
		assertEquals(ua.getName(), "N502i");
		assertEquals(ua.getVendorId(), "N");
		assertEquals(ua.getSeriesName(), "502i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N502i/c08");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "N502i");
		assertEquals(ua.getName(), "N502i");
		assertEquals(ua.getVendorId(), "N");
		assertEquals(ua.getSeriesName(), "502i");
		assertEquals(ua.getCacheSize(), 8);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P502i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "P502i");
		assertEquals(ua.getName(), "P502i");
		assertEquals(ua.getVendorId(), "P");
		assertEquals(ua.getSeriesName(), "502i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P502i/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "P502i");
		assertEquals(ua.getName(), "P502i");
		assertEquals(ua.getVendorId(), "P");
		assertEquals(ua.getSeriesName(), "502i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/NM502i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "NM502i");
		assertEquals(ua.getName(), "NM502i");
		assertEquals(ua.getVendorId(), "NM");
		assertEquals(ua.getSeriesName(), "502i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/NM502i/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "NM502i");
		assertEquals(ua.getName(), "NM502i");
		assertEquals(ua.getVendorId(), "NM");
		assertEquals(ua.getSeriesName(), "502i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO502i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "SO502i");
		assertEquals(ua.getName(), "SO502i");
		assertEquals(ua.getVendorId(), "SO");
		assertEquals(ua.getSeriesName(), "502i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F502it");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "F502it");
		assertEquals(ua.getName(), "F502it");
		assertEquals(ua.getVendorId(), "F");
		assertEquals(ua.getSeriesName(), "502i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F502it/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "F502it");
		assertEquals(ua.getName(), "F502it");
		assertEquals(ua.getVendorId(), "F");
		assertEquals(ua.getSeriesName(), "502i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N502it");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "N502it");
		assertEquals(ua.getName(), "N502it");
		assertEquals(ua.getVendorId(), "N");
		assertEquals(ua.getSeriesName(), "502i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N502it/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "N502it");
		assertEquals(ua.getName(), "N502it");
		assertEquals(ua.getVendorId(), "N");
		assertEquals(ua.getSeriesName(), "502i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO502iWM/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "SO502iWM");
		assertEquals(ua.getName(), "SO502iWM");
		assertEquals(ua.getVendorId(), "SO");
		assertEquals(ua.getSeriesName(), "502i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		// 821i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SH821i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "SH821i");
		assertEquals(ua.getName(), "SH821i");
		assertEquals(ua.getVendorId(), "SH");
		assertEquals(ua.getSeriesName(), "821i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SH821i/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "SH821i");
		assertEquals(ua.getName(), "SH821i");
		assertEquals(ua.getVendorId(), "SH");
		assertEquals(ua.getSeriesName(), "821i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N821i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "N821i");
		assertEquals(ua.getName(), "N821i");
		assertEquals(ua.getVendorId(), "N");
		assertEquals(ua.getSeriesName(), "821i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N821i/c08");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "N821i");
		assertEquals(ua.getName(), "N821i");
		assertEquals(ua.getVendorId(), "N");
		assertEquals(ua.getSeriesName(), "821i");
		assertEquals(ua.getCacheSize(), 8);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P821i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "P821i");
		assertEquals(ua.getName(), "P821i");
		assertEquals(ua.getVendorId(), "P");
		assertEquals(ua.getSeriesName(), "821i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P821i/c08");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "P821i");
		assertEquals(ua.getName(), "P821i");
		assertEquals(ua.getVendorId(), "P");
		assertEquals(ua.getSeriesName(), "821i");
		assertEquals(ua.getCacheSize(), 8);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		// 209i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D209i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "D209i");
		assertEquals(ua.getName(), "D209i");
		assertEquals(ua.getVendorId(), "D");
		assertEquals(ua.getSeriesName(), "209i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D209i/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "D209i");
		assertEquals(ua.getName(), "D209i");
		assertEquals(ua.getVendorId(), "D");
		assertEquals(ua.getSeriesName(), "209i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/ER209i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "ER209i");
		assertEquals(ua.getName(), "ER209i");
		assertEquals(ua.getVendorId(), "ER");
		assertEquals(ua.getSeriesName(), "209i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/ER209i/c15");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "ER209i");
		assertEquals(ua.getName(), "ER209i");
		assertEquals(ua.getVendorId(), "ER");
		assertEquals(ua.getSeriesName(), "209i");
		assertEquals(ua.getCacheSize(), 15);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F209i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "F209i");
		assertEquals(ua.getName(), "F209i");
		assertEquals(ua.getVendorId(), "F");
		assertEquals(ua.getSeriesName(), "209i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F209i/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "F209i");
		assertEquals(ua.getName(), "F209i");
		assertEquals(ua.getVendorId(), "F");
		assertEquals(ua.getSeriesName(), "209i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/KO209i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "KO209i");
		assertEquals(ua.getName(), "KO209i");
		assertEquals(ua.getVendorId(), "KO");
		assertEquals(ua.getSeriesName(), "209i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N209i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "N209i");
		assertEquals(ua.getName(), "N209i");
		assertEquals(ua.getVendorId(), "N");
		assertEquals(ua.getSeriesName(), "209i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N209i/c08");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "N209i");
		assertEquals(ua.getName(), "N209i");
		assertEquals(ua.getVendorId(), "N");
		assertEquals(ua.getSeriesName(), "209i");
		assertEquals(ua.getCacheSize(), 8);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P209i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "P209i");
		assertEquals(ua.getName(), "P209i");
		assertEquals(ua.getVendorId(), "P");
		assertEquals(ua.getSeriesName(), "209i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P209i/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "P209i");
		assertEquals(ua.getName(), "P209i");
		assertEquals(ua.getVendorId(), "P");
		assertEquals(ua.getSeriesName(), "209i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P209is");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "P209is");
		assertEquals(ua.getName(), "P209iS");
		assertEquals(ua.getVendorId(), "P");
		assertEquals(ua.getSeriesName(), "209i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P209is/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "P209is");
		assertEquals(ua.getName(), "P209iS");
		assertEquals(ua.getVendorId(), "P");
		assertEquals(ua.getSeriesName(), "209i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/R209i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "R209i");
		assertEquals(ua.getName(), "R209i");
		assertEquals(ua.getVendorId(), "R");
		assertEquals(ua.getSeriesName(), "209i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		// 651
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P651ps");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "P651ps");
		assertEquals(ua.getName(), "P651ps");
		assertEquals(ua.getVendorId(), "P");
		assertEquals(ua.getSeriesName(), "651");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P651ps/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "P651ps");
		assertEquals(ua.getName(), "P651ps");
		assertEquals(ua.getVendorId(), "P");
		assertEquals(ua.getSeriesName(), "651");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		// 691i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/R691i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "R691i");
		assertEquals(ua.getName(), "R691i");
		assertEquals(ua.getVendorId(), "R");
		assertEquals(ua.getSeriesName(), "691i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/R691i/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "R691i");
		assertEquals(ua.getName(), "R691i");
		assertEquals(ua.getVendorId(), "R");
		assertEquals(ua.getSeriesName(), "691i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		// 210i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F210i/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "F210i");
		assertEquals(ua.getName(), "F210i");
		assertEquals(ua.getVendorId(), "F");
		assertEquals(ua.getSeriesName(), "210i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N210i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "N210i");
		assertEquals(ua.getName(), "N210i");
		assertEquals(ua.getVendorId(), "N");
		assertEquals(ua.getSeriesName(), "210i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N210i/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "N210i");
		assertEquals(ua.getName(), "N210i");
		assertEquals(ua.getVendorId(), "N");
		assertEquals(ua.getSeriesName(), "210i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P210i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "P210i");
		assertEquals(ua.getName(), "P210i");
		assertEquals(ua.getVendorId(), "P");
		assertEquals(ua.getSeriesName(), "210i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P210i/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "P210i");
		assertEquals(ua.getName(), "P210i");
		assertEquals(ua.getVendorId(), "P");
		assertEquals(ua.getSeriesName(), "210i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/KO210i");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "KO210i");
		assertEquals(ua.getName(), "KO210i");
		assertEquals(ua.getVendorId(), "KO");
		assertEquals(ua.getSeriesName(), "210i");
		assertEquals(ua.getCacheSize(), 5);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/KO210i/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "KO210i");
		assertEquals(ua.getName(), "KO210i");
		assertEquals(ua.getVendorId(), "KO");
		assertEquals(ua.getSeriesName(), "210i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		// 671i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F671i/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "F671i");
		assertEquals(ua.getName(), "F671i");
		assertEquals(ua.getVendorId(), "F");
		assertEquals(ua.getSeriesName(), "671i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		////////////////////////////////////////////////////////////
		// i[h HTML 3.0 (̎ʏ)

		// 210i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D210i/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "D210i");
		assertEquals(ua.getName(), "D210i");
		assertEquals(ua.getVendorId(), "D");
		assertEquals(ua.getSeriesName(), "210i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO210i/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "SO210i");
		assertEquals(ua.getName(), "SO210i");
		assertEquals(ua.getVendorId(), "SO");
		assertEquals(ua.getSeriesName(), "210i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		// 503i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F503i/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "F503i");
		assertEquals(ua.getName(), "F503i");
		assertEquals(ua.getVendorId(), "F");
		assertEquals(ua.getSeriesName(), "503i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F503iS/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "F503iS");
		assertEquals(ua.getName(), "F503iS");
		assertEquals(ua.getVendorId(), "F");
		assertEquals(ua.getSeriesName(), "503i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P503i/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "P503i");
		assertEquals(ua.getName(), "P503i");
		assertEquals(ua.getVendorId(), "P");
		assertEquals(ua.getSeriesName(), "503i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P503iS/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "P503iS");
		assertEquals(ua.getName(), "P503iS");
		assertEquals(ua.getVendorId(), "P");
		assertEquals(ua.getSeriesName(), "503i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N503i/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "N503i");
		assertEquals(ua.getName(), "N503i");
		assertEquals(ua.getVendorId(), "N");
		assertEquals(ua.getSeriesName(), "503i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N503iS/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "N503iS");
		assertEquals(ua.getName(), "N503iS");
		assertEquals(ua.getVendorId(), "N");
		assertEquals(ua.getSeriesName(), "503i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO503i/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "SO503i");
		assertEquals(ua.getName(), "SO503i");
		assertEquals(ua.getVendorId(), "SO");
		assertEquals(ua.getSeriesName(), "503i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO503iS/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "SO503iS");
		assertEquals(ua.getName(), "SO503iS");
		assertEquals(ua.getVendorId(), "SO");
		assertEquals(ua.getSeriesName(), "503i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D503i/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "D503i");
		assertEquals(ua.getName(), "D503i");
		assertEquals(ua.getVendorId(), "D");
		assertEquals(ua.getSeriesName(), "503i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D503i/c10/serNMAIA000001");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "D503i");
		assertEquals(ua.getName(), "D503i");
		assertEquals(ua.getVendorId(), "D");
		assertEquals(ua.getSeriesName(), "503i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), "NMAIA000001");
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D503iS/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "D503iS");
		assertEquals(ua.getName(), "D503iS");
		assertEquals(ua.getVendorId(), "D");
		assertEquals(ua.getSeriesName(), "503i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		// 211i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F211i/c10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D211i/c10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N211i/c10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N211iS/c10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P211i/c10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P211iS/c10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO211i/c10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/R211i/c10");

		// 251i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SH251i/c10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SH251iS/c10");

		// 692i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/R692i/c10");

		// FOMA 2001
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N2001(c10)");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.FOMA);
		assertEquals(ua.getId(), "N2001");
		assertEquals(ua.getName(), "N2001");
		assertEquals(ua.getVendorId(), "N");
		assertEquals(ua.getSeriesName(), "2001");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		// FOMA 2002
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N2002(c100)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P2002(c100)");

		// FOMA 2101V
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D2101V(c100)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P2101V(c100)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P2101V(c100;serXXXXXXXXXXXXXXX;iccxxxxxxxxxxxxxxxxxxxx)");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.FOMA);
		assertEquals(ua.getId(), "P2101V");
		assertEquals(ua.getName(), "P2101V");
		assertEquals(ua.getVendorId(), "P");
		assertEquals(ua.getSeriesName(), "2101V");
		assertEquals(ua.getCacheSize(), 100);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), "XXXXXXXXXXXXXXX");
		assertEquals(ua.getIcc(), "xxxxxxxxxxxxxxxxxxxx");
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/2.0 MST_v_SH2101V(c100)");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.FOMA);
		assertEquals(ua.getId(), "MST_v_SH2101V");
		assertEquals(ua.getName(), "SH2101V");
		assertEquals(ua.getVendorId(), "SH");
		assertEquals(ua.getSeriesName(), "2101V");
		assertEquals(ua.getCacheSize(), 100);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/2.0 T2101V(c100)");

		////////////////////////////////////////////////////////////
		// i[h HTML 4.0 (ԃR[h)

		// 504i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D504i/c10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D504i/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D504i/c10/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F504i/c10/TB");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F504i/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F504i/c10/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F504iS/c10/TB");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F504iS/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F504iS/c10/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N504i/c10/TB");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "N504i");
		assertEquals(ua.getName(), "N504i");
		assertEquals(ua.getVendorId(), "N");
		assertEquals(ua.getSeriesName(), "504i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), AccessType.BROWSER_OR_ADF);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N504i/c10/TB/serNMAIA000001");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "N504i");
		assertEquals(ua.getName(), "N504i");
		assertEquals(ua.getVendorId(), "N");
		assertEquals(ua.getSeriesName(), "504i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), AccessType.BROWSER_OR_ADF);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), "NMAIA000001");
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N504i/c30/TD");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "N504i");
		assertEquals(ua.getName(), "N504i");
		assertEquals(ua.getVendorId(), "N");
		assertEquals(ua.getSeriesName(), "504i");
		assertEquals(ua.getCacheSize(), 30);
		assertEquals(ua.getAccessType(), AccessType.JAR);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N504i/c10/TJ");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "N504i");
		assertEquals(ua.getName(), "N504i");
		assertEquals(ua.getVendorId(), "N");
		assertEquals(ua.getSeriesName(), "504i");
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), AccessType.I_APPLI);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N504iS/c10/TB");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N504iS/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N504iS/c10/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO504i/c10/TB");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO504i/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO504i/c10/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P504i/c10/TB");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P504i/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P504i/c10/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P504iS/c10/TB");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P504iS/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P504iS/c10/TJ");

		// 251i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D251i/c10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D251iS/c10/TB");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F251i/c10/TB");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F251i/c10/c10/TB");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N251i/c10/TB");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N251iS/c10/TB");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P251iS/c10/TB");

		// 671i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F671iS/c10/TB");

		// 212i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F212i/c10/TB");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO212i/c10/TB");

		// 661i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F661i/c10/TB");

		// 672i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F672i/c10/TB");

		// 213i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO213i/c10/TB");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO213iS/c10/TB");

		// FOMA 2051
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F2051(c100;TB)");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.FOMA);
		assertEquals(ua.getId(), "F2051");
		assertEquals(ua.getName(), "F2051");
		assertEquals(ua.getVendorId(), "F");
		assertEquals(ua.getSeriesName(), "2051");
		assertEquals(ua.getCacheSize(), 100);
		assertEquals(ua.getAccessType(), AccessType.BROWSER_OR_ADF);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F2051(c100;TB;serXXXXXXXXXXXXXXX;iccxxxxxxxxxxxxxxxxxxxx)");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.FOMA);
		assertEquals(ua.getId(), "F2051");
		assertEquals(ua.getName(), "F2051");
		assertEquals(ua.getVendorId(), "F");
		assertEquals(ua.getSeriesName(), "2051");
		assertEquals(ua.getCacheSize(), 100);
		assertEquals(ua.getAccessType(), AccessType.BROWSER_OR_ADF);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), "XXXXXXXXXXXXXXX");
		assertEquals(ua.getIcc(), "xxxxxxxxxxxxxxxxxxxx");
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F2051(c100;TD)");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.FOMA);
		assertEquals(ua.getId(), "F2051");
		assertEquals(ua.getName(), "F2051");
		assertEquals(ua.getVendorId(), "F");
		assertEquals(ua.getSeriesName(), "2051");
		assertEquals(ua.getCacheSize(), 100);
		assertEquals(ua.getAccessType(), AccessType.JAR);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F2051(c100;TJ)");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.FOMA);
		assertEquals(ua.getId(), "F2051");
		assertEquals(ua.getName(), "F2051");
		assertEquals(ua.getVendorId(), "F");
		assertEquals(ua.getSeriesName(), "2051");
		assertEquals(ua.getCacheSize(), 100);
		assertEquals(ua.getAccessType(), AccessType.I_APPLI);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N2051(c100;TB)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N2051(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N2051(c100;TJ)");

		// FOMA 2102V
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P2102V(c100;TB)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P2102V(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P2102V(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F2102V(c100;TB)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F2102V(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F2102V(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N2102V(c100;TB)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N2102V(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N2102V(c100;TJ)");

		// FOMA 2701
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N2701(c100;TB)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N2701(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N2701(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N2701/c10/TB");

		////////////////////////////////////////////////////////////
		// i[h HTML 5.0 (uEU\\oCg)

		// 505i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D505i/c20/TB/W20H10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "D505i");
		assertEquals(ua.getName(), "D505i");
		assertEquals(ua.getVendorId(), "D");
		assertEquals(ua.getSeriesName(), "505i");
		assertEquals(ua.getCacheSize(), 20);
		assertEquals(ua.getAccessType(), AccessType.BROWSER_OR_ADF);
		assertEquals(ua.getWidth(), 20);
		assertEquals(ua.getHeight(), 10);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D505i/c20/TC/W20H10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "D505i");
		assertEquals(ua.getName(), "D505i");
		assertEquals(ua.getVendorId(), "D");
		assertEquals(ua.getSeriesName(), "505i");
		assertEquals(ua.getCacheSize(), 20);
		assertEquals(ua.getAccessType(), AccessType.BROWSER_NONE_IMAGE);
		assertEquals(ua.getWidth(), 20);
		assertEquals(ua.getHeight(), 10);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D505i/c20/TB/W20H10/serNMAIA000001");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "D505i");
		assertEquals(ua.getName(), "D505i");
		assertEquals(ua.getVendorId(), "D");
		assertEquals(ua.getSeriesName(), "505i");
		assertEquals(ua.getCacheSize(), 20);
		assertEquals(ua.getAccessType(), AccessType.BROWSER_OR_ADF);
		assertEquals(ua.getWidth(), 20);
		assertEquals(ua.getHeight(), 10);
		assertEquals(ua.getSer(), "NMAIA000001");
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D505i/c30/TD");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "D505i");
		assertEquals(ua.getName(), "D505i");
		assertEquals(ua.getVendorId(), "D");
		assertEquals(ua.getSeriesName(), "505i");
		assertEquals(ua.getCacheSize(), 30);
		assertEquals(ua.getAccessType(), AccessType.JAR);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D505i/c20/TJ");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PDC);
		assertEquals(ua.getId(), "D505i");
		assertEquals(ua.getName(), "D505i");
		assertEquals(ua.getVendorId(), "D");
		assertEquals(ua.getSeriesName(), "505i");
		assertEquals(ua.getCacheSize(), 20);
		assertEquals(ua.getAccessType(), AccessType.I_APPLI);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO505i/c20/TB/W21H09");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO505i/c20/TB/W18H08");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO505i/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO505i/c20/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SH505i/c20/TB/W24H12");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SH505i2/c20/TB/W24H12");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SH505i/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SH505i2/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SH505i/c20/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SH505i2/c20/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N505i/c20/TB/W20H10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N505i/c20/TB/W30H14");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N505i/c20/TB/W16H08");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N505i/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N505i/c20/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F505i/c20/TB/W20H10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F505i/c20/TB/W24H12");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F505i/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F505i/c20/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P505i/c20/TB/W20H10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P505i/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P505i/c20/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D505iS/c20/TB/W20H10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D505iS/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D505iS/c20/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P505iS/c20/TB/W20H10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P505iS/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P505iS/c20/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N505iS/c20/TB/W20H10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N505iS/c20/TB/W30H14");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N505iS/c20/TB/W16H08");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N505iS/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N505iS/c20/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO505iS/c20/TB/W20H10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO505iS/c20/TB/W40H21");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO505iS/c20/TB/W30H16");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO505iS/c20/TB/W16H08");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO505iS/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO505iS/c20/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SH505iS/c20/TB/W24H12");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SH505iS/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SH505iS/c20/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F505iGPS/c20/TB/W20H10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F505iGPS/c20/TB/W24H12");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F505iGPS/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F505iGPS/c20/TJ");

		// 252i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D252i/c10/TB/W25H12");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SH252i/c20/TB/W24H12");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P252i/c10/TB/W22H10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N252i/c10/TB/W22H10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N252i/c10/TB/W26H11");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N252i/c10/TB/W16H07");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P252iS/c10/TB/W22H10");

		// 506i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D506i/c20/TB/W20H10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D506i/c20/TB/W40H18");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D506i/c20/TB/W30H14");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D506i/c20/TB/W16H08");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D506i/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D506i/c20/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F506i/c20/TB/W20H10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F506i/c20/TB/W24H12");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F506i/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/F506i/c20/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N506i/c20/TB/W20H11");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N506i/c20/TB/W30H15");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N506i/c20/TB/W16H09");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N506i/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N506i/c20/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P506iC/c20/TB/W20H10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P506iC/c20/TB/W30H14");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P506iC/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P506iC/c20/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SH506iC/c20/TB/W24H12");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SH506iC/c20/TB/W40H19");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SH506iC/c20/TB/W20H10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SH506iC/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SH506iC/c20/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO506iC/c20/TB/W20H10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO506iC/c20/TB/W40H21");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO506iC/c20/TB/W30H16");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO506iC/c20/TB/W16H08");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO506iC/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO506iC/c20/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N506iS/c20/TB/W20H11");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N506iS/c20/TB/W30H15");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N506iS/c20/TB/W16H09");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N506iS/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N506iS/c20/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO506i/c20/TB/W20H10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO506i/c20/TB/W40H21");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO506i/c20/TB/W30H16");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO506i/c20/TB/W16H08");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO506i/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO506i/c20/TJ");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO506iS/c20/TB/W20H10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO506iS/c20/TB/W40H21");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO506iS/c20/TB/W30H16");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO506iS/c20/TB/W16H08");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO506iS/c30/TD");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/SO506iS/c20/TJ");

		// 253i
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D253i/c10/TB/W17H09");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D253i/c10/TB/W14H07");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D253i/c10/TB/W25H12");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D253i/c10/TB/W14H06");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N253i/c10/TB/W20H10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N253i/c10/TB/W26H12");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/N253i/c10/TB/W16H08");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P253i/c10/TB/W22H10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D253iWM/c10/TB/W27H08");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D253iWM/c10/TB/W22H06");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/D253iWM/c10/TB/W36H10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P253iS/c10/TB/W22H10");
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/P213i/c10/TB/W22H10");

		// 900i
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F900i(c100;TB;W22H12)");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.FOMA);
		assertEquals(ua.getId(), "F900i");
		assertEquals(ua.getName(), "F900i");
		assertEquals(ua.getVendorId(), "F");
		assertEquals(ua.getSeriesName(), "900i");
		assertEquals(ua.getCacheSize(), 100);
		assertEquals(ua.getAccessType(), AccessType.BROWSER_OR_ADF);
		assertEquals(ua.getWidth(), 22);
		assertEquals(ua.getHeight(), 12);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F900i(c100;TC;W22H12)");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.FOMA);
		assertEquals(ua.getId(), "F900i");
		assertEquals(ua.getName(), "F900i");
		assertEquals(ua.getVendorId(), "F");
		assertEquals(ua.getSeriesName(), "900i");
		assertEquals(ua.getCacheSize(), 100);
		assertEquals(ua.getAccessType(), AccessType.BROWSER_NONE_IMAGE);
		assertEquals(ua.getWidth(), 22);
		assertEquals(ua.getHeight(), 12);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F900i(c100;TB;W22H12;serXXXXXXXXXXXXXXX;iccxxxxxxxxxxxxxxxxxxxx)");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.FOMA);
		assertEquals(ua.getId(), "F900i");
		assertEquals(ua.getName(), "F900i");
		assertEquals(ua.getVendorId(), "F");
		assertEquals(ua.getSeriesName(), "900i");
		assertEquals(ua.getCacheSize(), 100);
		assertEquals(ua.getAccessType(), AccessType.BROWSER_OR_ADF);
		assertEquals(ua.getWidth(), 22);
		assertEquals(ua.getHeight(), 12);
		assertEquals(ua.getSer(), "XXXXXXXXXXXXXXX");
		assertEquals(ua.getIcc(), "xxxxxxxxxxxxxxxxxxxx");
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F900i(c100;TB;W18H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F900i(c100;TB;W28H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F900i(c100;TD)");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.FOMA);
		assertEquals(ua.getId(), "F900i");
		assertEquals(ua.getName(), "F900i");
		assertEquals(ua.getVendorId(), "F");
		assertEquals(ua.getSeriesName(), "900i");
		assertEquals(ua.getCacheSize(), 100);
		assertEquals(ua.getAccessType(), AccessType.JAR);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F900i(c100;TJ)");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.FOMA);
		assertEquals(ua.getId(), "F900i");
		assertEquals(ua.getName(), "F900i");
		assertEquals(ua.getVendorId(), "F");
		assertEquals(ua.getSeriesName(), "900i");
		assertEquals(ua.getCacheSize(), 100);
		assertEquals(ua.getAccessType(), AccessType.I_APPLI);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N900i(c100;TB;W24H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N900i(c100;TB;W20H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N900i(c100;TB;W30H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N900i(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N900i(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P900i(c100;TB;W24H11)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P900i(c100;TB;W20H09)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P900i(c100;TB;W30H14)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P900i(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P900i(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH900i(c100;TB;W24H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH900i(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH900i(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F900iT(c100;TB;W22H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F900iT(c100;TB;W18H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F900iT(c100;TB;W28H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F900iT(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F900iT(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P900iV(c100;TB;W24H11)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P900iV(c100;TB;W20H09)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P900iV(c100;TB;W30H14)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P900iV(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P900iV(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N900iS(c100;TB;W24H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N900iS(c100;TB;W20H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N900iS(c100;TB;W30H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N900iS(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N900iS(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D900i(c100;TB;W20H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D900i(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D900i(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F900iC(c100;TB;W22H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F900iC(c100;TB;W18H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F900iC(c100;TB;W28H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F900iC(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F900iC(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N900iL(c100;TB;W24H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N900iL(c100;TB;W20H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N900iL(c100;TB;W30H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N900iL(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N900iL(c100;TJ)");

		ua = new ImodeUserAgentImpl("WLAN_DoCoMo/2.0 N900iL(c100;TB;W24H12)");
		assertEquals(ua.getNetworkType(), NetworkType.WLAN);
		assertEquals(ua.getType(), ImodeType.FOMA);
		assertEquals(ua.getId(), "N900iL");
		assertEquals(ua.getName(), "N900iL");
		assertEquals(ua.getVendorId(), "N");
		assertEquals(ua.getSeriesName(), "900i");
		assertEquals(ua.getCacheSize(), 100);
		assertEquals(ua.getAccessType(), AccessType.BROWSER_OR_ADF);
		assertEquals(ua.getWidth(), 24);
		assertEquals(ua.getHeight(), 12);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), null);
		assertEquals(ua.getBrowserName(), null);

		ua = new ImodeUserAgentImpl("WLAN_DoCoMo/2.0 N900iL(c100;TB;W20H10)");
		ua = new ImodeUserAgentImpl("WLAN_DoCoMo/2.0 N900iL(c100;TB;W30H15)");
		ua = new ImodeUserAgentImpl("WLAN_DoCoMo/2.0 N900iL(c100;TC;W24H12)");
		ua = new ImodeUserAgentImpl("WLAN_DoCoMo/2.0 N900iL(c100;TC;W20H10)");
		ua = new ImodeUserAgentImpl("WLAN_DoCoMo/2.0 N900iL(c100;TC;W30H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N900iG(c100;TB;W24H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N900iG(c100;TB;W20H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N900iG(c100;TB;W30H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N900iG(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N900iG(c100;TJ)");

		// 880i
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F880iES(c100;TB;W20H08)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F880iES(c100;TB;W16H08)");

		// 901i
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH901iC(c100;TB;W24H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH901iC(c100;TB;W20H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH901iC(c100;TB;W30H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH901iC(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH901iC(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F901iC(c100;TB;W23H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F901iC(c100;TB;W19H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F901iC(c100;TB;W28H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F901iC(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F901iC(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N901iC(c100;TB;W24H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N901iC(c100;TB;W20H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N901iC(c100;TB;W30H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N901iC(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N901iC(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D901i(c100;TB;W23H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D901i(c100;TB;W19H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D901i(c100;TB;W28H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D901i(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D901i(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P901i(c100;TB;W24H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P901i(c100;TB;W20H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P901i(c100;TB;W30H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P901i(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P901i(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH901iS(c100;TB;W24H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH901iS(c100;TB;W20H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH901iS(c100;TB;W30H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH901iS(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH901iS(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F901iS(c100;TB;W23H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F901iS(c100;TB;W19H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F901iS(c100;TB;W28H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F901iS(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F901iS(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D901iS(c100;TB;W23H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D901iS(c100;TB;W19H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D901iS(c100;TB;W28H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D901iS(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D901iS(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P901iS(c100;TB;W24H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P901iS(c100;TB;W20H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P901iS(c100;TB;W30H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P901iS(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P901iS(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N901iS(c100;TB;W24H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N901iS(c100;TB;W20H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N901iS(c100;TB;W30H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N901iS(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N901iS(c100;TJ)");

		// 700i
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F700i(c100;TB;W23H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F700i(c100;TB;W19H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F700i(c100;TB;W28H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F700i(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F700i(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH700i(c100;TB;W24H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH700i(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH700i(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N700i(c100;TB;W24H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N700i(c100;TB;W20H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N700i(c100;TB;W30H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N700i(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N700i(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P700i(c100;TB;W24H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P700i(c100;TB;W20H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P700i(c100;TB;W30H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P700i(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P700i(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F700iS(c100;TB;W23H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F700iS(c100;TB;W19H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F700iS(c100;TB;W28H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F700iS(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F700iS(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH700iS(c100;TB;W24H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH700iS(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH700iS(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SA700iS(c100;TB;W24H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SA700iS(c100;TB;W20H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SA700iS(c100;TB;W30H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SA700iS(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SA700iS(c100;TJ)");

		// 851i
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH851i(c100;TB;W24H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH851i(c100;TB;W20H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 SH851i(c100;TB;W30H15)");

		// 881i
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F881iES(c100;TB;W20H08)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 F881iES(c100;TB;W16H08)");

		// 701i
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D701i(c100;TB;W23H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D701i(c100;TB;W19H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D701i(c100;TB;W28H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D701i(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D701i(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N701i(c100;TB;W24H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N701i(c100;TB;W20H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N701i(c100;TB;W30H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N701i(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 N701i(c100;TJ)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P701iD(c100;TB;W24H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P701iD(c100;TB;W20H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P701iD(c100;TB;W30H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P701iD(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 P701iD(c100;TJ)");

		// 702i
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D702i(c100;TB;W23H12)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D702i(c100;TB;W19H10)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D702i(c100;TB;W28H15)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D702i(c100;TD)");
		ua = new ImodeUserAgentImpl("DoCoMo/2.0 D702i(c100;TJ)");

		// J[ir
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/ex_navi_1.0_AA1234");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.CAR_NAVI);
		assertEquals(ua.getId(), "ex_navi");
		assertEquals(ua.getName(), "ex_navi");
		assertEquals(ua.getVendorId(), null);
		assertEquals(ua.getSeriesName(), null);
		assertEquals(ua.getCacheSize(), 0);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), new Float("1.0"));
		assertEquals(ua.getBrowserName(), "AA1234");

		ua = new ImodeUserAgentImpl("DoCoMo/1.0/ex_navi_2.0_AA5678");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.CAR_NAVI);
		assertEquals(ua.getId(), "ex_navi");
		assertEquals(ua.getName(), "ex_navi");
		assertEquals(ua.getVendorId(), null);
		assertEquals(ua.getSeriesName(), null);
		assertEquals(ua.getCacheSize(), 0);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), new Float("2.0"));
		assertEquals(ua.getBrowserName(), "AA5678");

		// vXe
		ua = new ImodeUserAgentImpl("DoCoMo/1.0/ex_ps1000/c10");
		assertEquals(ua.getNetworkType(), NetworkType.IMODE);
		assertEquals(ua.getType(), ImodeType.PLAYSTATION);
		assertEquals(ua.getId(), "ex_ps1000");
		assertEquals(ua.getName(), "ex_ps1000");
		assertEquals(ua.getVendorId(), null);
		assertEquals(ua.getSeriesName(), null);
		assertEquals(ua.getCacheSize(), 10);
		assertEquals(ua.getAccessType(), null);
		assertEquals(ua.getWidth(), 0);
		assertEquals(ua.getHeight(), 0);
		assertEquals(ua.getSer(), null);
		assertEquals(ua.getIcc(), null);
		assertEquals(ua.getTrustedId(), null);
		assertEquals(ua.getHtmlVersion(), new Float("2.0"));
		assertEquals(ua.getBrowserName(), null);
	}

}
