/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.imode;

import jp.sourceforge.livez.IllegalUserIdException;
import junit.framework.TestCase;

public final class UIDImplTest extends TestCase {

	public void test() throws Exception {
		UID uid = new UIDImpl("00XXXXXXXXXX");
		assertEquals(uid.getValue(), "00XXXXXXXXXX");
		assertTrue(uid.getType() == UIDType.PDC);
		assertEquals(uid.getUserId(), "XXXXXXXXXX");
		assertEquals(uid.isMember(), true);
		assertEquals(uid.isGuest(), false);

		uid = new UIDImpl("01XXXXXXXXXX");
		assertEquals(uid.getValue(), "01XXXXXXXXXX");
		assertTrue(uid.getType() == UIDType.FOMA);
		assertEquals(uid.getUserId(), "XXXXXXXXXX");
		assertEquals(uid.isMember(), true);
		assertEquals(uid.isGuest(), false);

		uid = new UIDImpl("NULLGWDOCOMO");
		assertEquals(uid.getValue(), "NULLGWDOCOMO");
		assertTrue(uid.getType() == null);
		assertEquals(uid.getUserId(), null);
		assertEquals(uid.isMember(), false);
		assertEquals(uid.isGuest(), true);

		try {
			new UIDImpl("");
		} catch (IllegalUserIdException e) {
			assertNotNull(e.getMessage());
		}
	}

}
