/*
 * Copyright (C) 2005-2006 Kouji Sugisawa. All rights reserved.
 */

package jp.sourceforge.livez.util;

import java.awt.image.BufferedImage;

import jp.sourceforge.livez.images.ImageType;

import junit.framework.TestCase;

/**
 * 
 * @author V _
 */
public final class ImageTypeTest extends TestCase {

	public void testGetAccessType() {
		ImageType imageType;

		imageType = ImageType.GIF_1BIT;
		assertEquals(imageType.getFormatName(), "gif");
		assertEquals(imageType.getMimeType(), "image/gif");
		assertEquals(imageType.getSuffix(), "gif");
		assertEquals(imageType.getBufferedImageType(), BufferedImage.TYPE_BYTE_BINARY);
		assertNull(imageType.getIndexColorModel());

		imageType = ImageType.GIF_2BIT;
		assertEquals(imageType.getFormatName(), "gif");
		assertEquals(imageType.getMimeType(), "image/gif");
		assertEquals(imageType.getSuffix(), "gif");
		assertEquals(imageType.getBufferedImageType(), BufferedImage.TYPE_BYTE_BINARY);
		assertNull(imageType.getIndexColorModel());

		imageType = ImageType.GIF_8BIT;
		assertEquals(imageType.getFormatName(), "gif");
		assertEquals(imageType.getMimeType(), "image/gif");
		assertEquals(imageType.getSuffix(), "gif");
		assertEquals(imageType.getBufferedImageType(), BufferedImage.TYPE_BYTE_INDEXED);
		assertNull(imageType.getIndexColorModel());

		imageType = ImageType.JPEG;
		assertEquals(imageType.getFormatName(), "jpeg");
		assertEquals(imageType.getMimeType(), "image/jpeg");
		assertEquals(imageType.getSuffix(), "jpg");
		assertEquals(imageType.getBufferedImageType(), -1);
		assertNull(imageType.getIndexColorModel());

		imageType = ImageType.BMP_1BIT;
		assertEquals(imageType.getFormatName(), "bmp");
		assertEquals(imageType.getMimeType(), "image/bmp");
		assertEquals(imageType.getSuffix(), "bmp");
		assertEquals(imageType.getBufferedImageType(), BufferedImage.TYPE_BYTE_BINARY);

		imageType = ImageType.BMP_2BIT;
		assertEquals(imageType.getFormatName(), "bmp");
		assertEquals(imageType.getMimeType(), "image/bmp");
		assertEquals(imageType.getSuffix(), "bmp");
		assertEquals(imageType.getBufferedImageType(), BufferedImage.TYPE_BYTE_BINARY);

		imageType = ImageType.PNG_8BIT;
		assertEquals(imageType.getFormatName(), "png");
		assertEquals(imageType.getMimeType(), "image/png");
		assertEquals(imageType.getSuffix(), "png");
		assertEquals(imageType.getBufferedImageType(), BufferedImage.TYPE_BYTE_INDEXED);
		assertNull(imageType.getIndexColorModel());

		imageType = ImageType.PNG;
		assertEquals(imageType.getFormatName(), "png");
		assertEquals(imageType.getMimeType(), "image/png");
		assertEquals(imageType.getSuffix(), "png");
		assertEquals(imageType.getBufferedImageType(), -1);
		assertNull(imageType.getIndexColorModel());
	}

}
