/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.search.SearchTerm;

public final class FlagTerm
extends SearchTerm {
    private static final long serialVersionUID = 1L;
    protected boolean set;
    protected Flags flags;

    public FlagTerm(Flags flags, boolean set) {
        this.flags = flags;
        this.set = set;
    }

    public Flags getFlags() {
        return (Flags)this.flags.clone();
    }

    public boolean getTestSet() {
        return this.set;
    }

    public boolean match(Message msg) {
        try {
            Flags f = msg.getFlags();
            if (this.set) {
                return f.contains(this.flags);
            }
            Flags.Flag[] sf = this.flags.getSystemFlags();
            int i = 0;
            while (i < sf.length) {
                if (f.contains(sf[i])) {
                    return false;
                }
                ++i;
            }
            String[] s = this.flags.getUserFlags();
            int i2 = 0;
            while (i2 < s.length) {
                if (f.contains(s[i2])) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FlagTerm)) {
            return false;
        }
        FlagTerm ft = (FlagTerm)obj;
        return ft.set == this.set && ft.flags.equals(this.flags);
    }

    public int hashCode() {
        if (this.set) {
            return this.flags.hashCode();
        }
        return ~this.flags.hashCode();
    }
}

