/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.mail.util;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.QDecoderStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeUtility;
import jp.sourceforge.livez.mail.util.JISAutoDetect;
import jp.sourceforge.livez.mail.util.UTF7;
import jp.sourceforge.livez.mail.util.WindowsEUCJP;
import jp.sourceforge.livez.mail.util.WindowsJIS;

public final class MailUtils {
    public static final String decodeText(String etext) {
        if (etext == null) {
            return null;
        }
        if (etext.indexOf(27) > -1) {
            try {
                return WindowsJIS.decode(etext.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalError();
            }
        }
        return new RFC2047Decoder(etext).get();
    }

    private static final int indexOfNonLWSP(String source, int startIndex, boolean decrease) {
        int inc = 1;
        if (decrease) {
            inc = -1;
        }
        int index = startIndex;
        while (index >= 0 && index < source.length()) {
            char c = source.charAt(index);
            if (!MailUtils.isLWSP(c)) {
                return index;
            }
            index += inc;
        }
        return -1;
    }

    private static final int indexOfLWSP(String source, int startIndex, boolean decrease, char additionalDelimiter) {
        int inc = 1;
        if (decrease) {
            inc = -1;
        }
        int index = startIndex;
        while (index >= 0 && index < source.length()) {
            char c = source.charAt(index);
            if (MailUtils.isLWSP(c) || c == additionalDelimiter) {
                return index;
            }
            index += inc;
        }
        return -1;
    }

    private static final boolean isLWSP(char c) {
        return c == '\r' || c == '\n' || c == ' ' || c == '\t';
    }

    private static byte[] decodeByTES(String s, String tes) throws MessagingException {
        try {
            FilterInputStream is;
            ByteArrayInputStream bis = new ByteArrayInputStream(ASCIIUtility.getBytes(s));
            if (tes.equalsIgnoreCase("B")) {
                is = new BASE64DecoderStream(bis);
            } else if (tes.equalsIgnoreCase("Q")) {
                is = new QDecoderStream(bis);
            } else {
                throw new UnsupportedEncodingException(tes);
            }
            int count = bis.available();
            byte[] bytes = new byte[count];
            try {
                count = ((InputStream)is).read(bytes, 0, count);
            }
            catch (IOException e) {
                ByteArrayInputStream sStream = new ByteArrayInputStream(s.getBytes());
                InputStream sDecodeStream = MimeUtility.decode(sStream, "base64");
                bytes = new byte[sDecodeStream.available()];
                sDecodeStream.read(bytes, 0, bytes.length);
                return bytes;
            }
            if (count != bytes.length) {
                byte[] w = new byte[count];
                System.arraycopy(bytes, 0, w, 0, count);
                bytes = w;
            }
            return bytes;
        }
        catch (IOException e) {
            throw new RuntimeException("CANT HAPPEN");
        }
    }

    static class RFC2047Decoder {
        private String source;
        private String pooledCES;
        private byte[] pooledBytes;
        private StringBuffer buf;
        private int pos = 0;
        private int startIndex;
        private int endIndex;

        public RFC2047Decoder(String source) {
            this.source = source;
            this.buf = new StringBuffer(source.length());
            this.parse();
        }

        private void parse() {
            while (this.hasEncodedWord()) {
                String work = this.source.substring(this.pos, this.startIndex);
                if (MailUtils.indexOfNonLWSP(work, 0, false) > -1) {
                    this.sweepPooledBytes();
                    this.buf.append(work);
                }
                this.parseWord();
            }
            this.sweepPooledBytes();
            if (this.pos == 0) {
                this.buf.append(JISAutoDetect.decode(this.source));
            } else {
                this.buf.append(this.source.substring(this.pos));
            }
        }

        private boolean hasEncodedWord() {
            this.startIndex = this.source.indexOf("=?", this.pos);
            if (this.startIndex == -1) {
                return false;
            }
            this.endIndex = this.source.indexOf("?=", this.startIndex + 2);
            if (this.endIndex == -1) {
                return false;
            }
            int i = MailUtils.indexOfLWSP(this.source, this.startIndex + 2, false, '\u0000');
            this.endIndex += 2;
            return true;
        }

        private void parseWord() {
            try {
                int s = this.startIndex + 2;
                int e = this.source.indexOf(63, s);
                if (e == this.endIndex - 2) {
                    throw new RuntimeException();
                }
                String ces = this.source.substring(s, e);
                if (ces.equalsIgnoreCase("UNKNOWN") || ces.equalsIgnoreCase("SHIFT_JIS")) {
                    ces = "Windows-31J";
                }
                if (!"UTF-7".equalsIgnoreCase(ces)) {
                    "".getBytes(ces);
                }
                if ((e = this.source.indexOf(63, s = e + 1)) == this.endIndex - 2) {
                    throw new RuntimeException();
                }
                String tes = this.source.substring(s, e);
                byte[] bytes = MailUtils.decodeByTES(this.source.substring(e + 1, this.endIndex - 2), tes);
                if (ces.equals(this.pooledCES)) {
                    byte[] w = new byte[this.pooledBytes.length + bytes.length];
                    System.arraycopy(this.pooledBytes, 0, w, 0, this.pooledBytes.length);
                    System.arraycopy(bytes, 0, w, this.pooledBytes.length, bytes.length);
                    this.pooledBytes = w;
                } else {
                    this.sweepPooledBytes();
                    this.pooledCES = ces;
                    this.pooledBytes = bytes;
                }
            }
            catch (Exception ex) {
                this.buf.append(this.source.substring(this.startIndex, this.endIndex));
            }
            this.pos = this.endIndex;
        }

        private void sweepPooledBytes() {
            if (this.pooledBytes == null) {
                return;
            }
            try {
                if ("ISO-2022-JP".equalsIgnoreCase(this.pooledCES)) {
                    this.buf.append(WindowsJIS.decode(this.pooledBytes));
                } else if ("euc-jp".equalsIgnoreCase(this.pooledCES)) {
                    this.buf.append(WindowsEUCJP.decode(this.pooledBytes));
                } else if ("utf-7".equalsIgnoreCase(this.pooledCES)) {
                    try {
                        this.buf.append(UTF7.decode(this.pooledBytes));
                    }
                    catch (IOException e) {
                        this.buf.append(new String(this.pooledBytes, "ISO-8859-1"));
                    }
                } else {
                    this.buf.append(new String(this.pooledBytes, this.pooledCES));
                }
            }
            catch (IOException e) {
                throw new InternalError("CANT HAPPEN: Illegal encoding = " + this.pooledCES);
            }
            this.pooledCES = null;
            this.pooledBytes = null;
        }

        public String get() {
            return new String(this.buf);
        }
    }
}

