/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.ezweb;

import javax.servlet.http.HttpServletRequest;
import jp.sourceforge.livez.IllegalUserIdException;
import jp.sourceforge.livez.ezweb.SubscriberId;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

final class SubscriberIdImpl
implements SubscriberId {
    private static final long serialVersionUID = 1L;
    private String value = null;

    public SubscriberIdImpl(String subscriberId) throws NullPointerException, IllegalUserIdException {
        if (!SubscriberIdImpl.validate(subscriberId)) {
            throw new IllegalUserIdException();
        }
        this.value = subscriberId;
    }

    public SubscriberIdImpl(HttpServletRequest request) throws NullPointerException, IllegalUserIdException {
        String subscriberId = request.getHeader("x-up-subno");
        if (!SubscriberIdImpl.validate(subscriberId)) {
            throw new IllegalUserIdException();
        }
        this.value = subscriberId;
    }

    private static boolean validate(String subscriberId) throws NullPointerException {
        if (subscriberId == null) {
            throw new NullPointerException();
        }
        String key = "^(05[0-9]{2}0[0-9]{9,}|(05[0-9]{2}[123456789](01|03|05)|(0700|0701|0702|0703|0704|0705|0706|0707|0800|0801|0802)[0-9]{3})[0-9]{7,})_(((W[23456789]\\.ez[a-z])|w0\\.upa|fwswua01\\.upb)\\.ido|([a-z]([23456789]|[a-z])|x(23469)s?|x7.xx)\\.ezweb)\\.ne\\.jp$";
        return subscriberId.matches(key) && subscriberId.length() <= 40;
    }

    public final String getValue() {
        return this.value;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

