/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.mail;

import java.util.Properties;
import jp.sourceforge.livez.mail.MailProtocol;
import jp.sourceforge.livez.mail.ReceiveProtocolType;
import jp.sourceforge.livez.mail.SendProtocolType;
import org.apache.commons.lang.BooleanUtils;

public class MailProfile {
    protected String username = "root";
    protected String address = "root@localhost";
    protected String reply = "";
    protected MailProtocol send = new MailProtocol();
    protected MailProtocol receive = new MailProtocol();

    public MailProfile() {
        this.send.protocol = SendProtocolType.SMTP.toString().toLowerCase();
        this.receive.protocol = ReceiveProtocolType.POP3.toString().toLowerCase();
    }

    public final String getUsername() {
        return this.username;
    }

    public final void setUsername(String username) {
        this.username = username;
    }

    public final String getAddress() {
        return this.address;
    }

    public final void setAddress(String address) {
        this.address = address;
    }

    public final String getReply() {
        return this.reply;
    }

    public final void setReply(String reply) {
        this.reply = reply;
    }

    public final SendProtocolType getSendProtocol() {
        return SendProtocolType.valueOf(this.send.protocol.toUpperCase());
    }

    public final String getSendServer() {
        return this.send.hostname;
    }

    public final void setSendServer(String hostname) {
        this.send.hostname = hostname;
    }

    public final int getSendPort() {
        return this.send.port;
    }

    public final void setSendPort(int port) {
        this.send.port = port;
    }

    public final boolean isSendAuth() {
        return this.send.auth;
    }

    public final void setSendAuth(boolean auth) {
        this.send.auth = auth;
    }

    public final boolean isSendAuthSSL() {
        return this.send.authSSL;
    }

    public final void setSendAuthSSL(boolean ssl) {
        this.send.authSSL = ssl;
    }

    public final String getSendAuthAccount() {
        return this.send.account;
    }

    public final void setSendAuthAccount(String account) {
        this.send.account = account;
    }

    public final String getSendAuthPassword() {
        return this.send.password;
    }

    public final void setSendAuthPassword(String password) {
        this.send.password = password;
    }

    public final int getSendAuthTimeout() {
        return this.send.connectionTimeout;
    }

    public final void setSendAuthTimeout(int timeout) {
        this.send.connectionTimeout = timeout;
    }

    public final boolean isSendSSL() {
        return this.send.SSL;
    }

    public final void setSendSSL(boolean ssl) {
        this.send.SSL = ssl;
    }

    public final int getSendTimeout() {
        return this.send.timeout;
    }

    public final void setSendTimeout(int timeout) {
        this.send.timeout = timeout;
    }

    public final ReceiveProtocolType getReceiveProtocol() {
        return ReceiveProtocolType.valueOf(this.receive.protocol.toUpperCase());
    }

    public final void setReceiveProtocol(ReceiveProtocolType protocol) {
        this.receive.protocol = protocol.toString().toLowerCase();
    }

    public final String getReceiveServer() {
        return this.receive.hostname;
    }

    public final void setReceiveServer(String hostname) {
        this.receive.hostname = hostname;
    }

    public final int getReceivePort() {
        return this.receive.port;
    }

    public final void setReceivePort(int port) {
        this.receive.port = port;
    }

    public final boolean isReceiveAuth() {
        return true;
    }

    public final boolean isReceiveAuthSSL() {
        return this.receive.authSSL;
    }

    public final void setReceiveAuthSSL(boolean ssl) {
        this.receive.authSSL = ssl;
    }

    public final String getReceiveAuthAccount() {
        return this.receive.account;
    }

    public final void setReceiveAuthAccount(String account) {
        this.receive.account = account;
    }

    public final String getReceiveAuthPassword() {
        return this.receive.password;
    }

    public final void setReceiveAuthPassword(String password) {
        this.receive.password = password;
    }

    public final int getReceiveAuthTimeout() {
        return this.receive.connectionTimeout;
    }

    public final void setReceiveAuthTimeout(int timeout) {
        this.receive.connectionTimeout = timeout;
    }

    public final boolean isReceiveSSL() {
        return this.receive.SSL;
    }

    public final void setReceiveSSL(boolean ssl) {
        this.receive.SSL = ssl;
    }

    public final int getReceiveTimeout() {
        return this.receive.timeout;
    }

    public final void setReceiveTimeout(int timeout) {
        this.receive.timeout = timeout;
    }

    public final void setAccount(String account) {
        this.setSendAuthAccount(account);
        this.setReceiveAuthAccount(account);
    }

    public final void setPassword(String password) {
        this.setSendAuthPassword(password);
        this.setReceiveAuthPassword(password);
    }

    public final void setTimeout(int timeout) {
        this.setSendAuthTimeout(timeout);
        this.setReceiveAuthTimeout(timeout);
    }

    public Properties getProperties() {
        int i;
        Properties props = new Properties();
        if (this.address != null && this.send.account != null && (i = this.address.indexOf(64)) > -1 && this.address.length() > i + 1) {
            props.setProperty("mail.host", this.address.substring(i + 1));
            props.setProperty("mail.user", this.send.account);
            props.setProperty("mail.from", this.address);
        }
        props.setProperty("mail.transport.protocol", this.send.protocol);
        props.setProperty("mail." + this.send.protocol + ".host", this.send.hostname);
        if (this.send.port > 0) {
            props.setProperty("mail." + this.send.protocol + ".port", String.valueOf(this.send.port));
        }
        props.setProperty("mail." + this.send.protocol + ".from", this.address);
        if (this.send.auth) {
            props.setProperty("mail." + this.send.protocol + ".user", this.send.account);
            props.setProperty("mail." + this.send.protocol + ".auth", BooleanUtils.toStringTrueFalse((boolean)this.send.auth));
            if (this.send.connectionTimeout > 0) {
                props.setProperty("mail." + this.send.protocol + ".connectiontimeout", String.valueOf(this.send.connectionTimeout * 1000));
            }
        }
        if (this.send.timeout > 0) {
            props.setProperty("mail." + this.send.protocol + ".timeout", String.valueOf(this.send.timeout * 1000));
        }
        props.setProperty("mail.store.protocol", this.receive.protocol);
        props.setProperty("mail." + this.receive.protocol + ".host", this.receive.hostname);
        if (this.receive.port > 0) {
            props.setProperty("mail." + this.receive.protocol + ".port", String.valueOf(this.receive.port));
        }
        props.setProperty("mail." + this.receive.protocol + ".user", this.receive.account);
        if (this.receive.connectionTimeout > 0) {
            props.setProperty("mail." + this.receive.protocol + ".connectiontimeout", String.valueOf(this.receive.connectionTimeout * 1000));
        }
        if (this.receive.timeout > 0) {
            props.setProperty("mail." + this.receive.protocol + ".timeout", String.valueOf(this.receive.timeout * 1000));
        }
        if (this.receive.authSSL && ReceiveProtocolType.POP3.toString().equalsIgnoreCase(this.receive.protocol)) {
            props.setProperty("mail." + this.receive.protocol + ".apop.enable", "true");
        }
        props.setProperty("mail.mime.address.strict", "false");
        System.setProperty("mail.mime.base64.ignoreerrors", "true");
        System.setProperty("mail.mime.charset", "ISO-2022-JP");
        return props;
    }
}

