/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.mail;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import jp.sourceforge.livez.mail.MailMessage;
import jp.sourceforge.livez.mail.MailMessageImpl;
import jp.sourceforge.livez.mail.MailProfile;

public final class MailSender {
    private MailProfile profile = null;
    private Session session = null;
    private Transport transport = null;

    public MailSender(MailProfile profile, boolean debug) {
        this.profile = profile;
        Properties prop = profile.getProperties();
        if (debug) {
            prop.put("mail.debug", "true");
        }
        this.session = Session.getInstance((Properties)prop, null);
    }

    public MailSender(MailProfile profile) {
        this(profile, false);
    }

    public final void connect() throws MessagingException {
        this.connect(this.profile.send.account, this.profile.send.password);
    }

    private final void connect(String account, String password) throws MessagingException {
        this.disconnect();
        this.transport = this.session.getTransport();
        this.transport.connect(this.profile.send.hostname, this.profile.send.port, account, password);
    }

    public final boolean isConnected() {
        return this.transport != null && this.transport.isConnected();
    }

    public final void disconnect() {
        if (this.isConnected()) {
            try {
                this.transport.close();
                this.transport = null;
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
    }

    private final MimeMessage createMimeMessage() {
        return new MimeMessage(this.session);
    }

    public final MailMessage createMailMessage() {
        return new MailMessageImpl(this.createMimeMessage());
    }

    public final MailMessage createReplyMailMessage(String messageId) {
        return this.createReplyMailMessage(messageId, null, null);
    }

    public final MailMessage createReplyMailMessage(String messageId, String[] references, String[] inReplyTo) {
        if (messageId == null) {
            return this.createMailMessage();
        }
        MimeMessage message = this.createMimeMessage();
        try {
            message.addHeader("In-Reply-To", messageId);
            StringBuffer buf = new StringBuffer();
            if (references != null && references.length > 0) {
                int index = 0;
                while (index < references.length) {
                    buf.append(references[index]);
                    buf.append(' ');
                    ++index;
                }
            } else if (inReplyTo != null && inReplyTo.length > 0) {
                int index = 0;
                while (index < inReplyTo.length) {
                    buf.append(inReplyTo[index]);
                    buf.append(' ');
                    ++index;
                }
            }
            buf.append(messageId);
            message.addHeader("References", buf.toString());
            message.setFlag(Flags.Flag.ANSWERED, true);
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return new MailMessageImpl(message);
    }

    public final MailMessage createReplyMailMessage(MailMessage mail) {
        return this.createReplyMailMessage(mail.getMessageId(), mail.getHeader("References"), mail.getHeader("In-Reply-To"));
    }

    public final void send(MailMessage message) throws MessagingException {
        MimeMessage msg = ((MailMessageImpl)message).message;
        this.send(msg, msg.getAllRecipients());
    }

    public final void send(MailMessage message, Address[] recipients) throws MessagingException {
        this.send(((MailMessageImpl)message).message, recipients);
    }

    public final void send(MimeMessage message, Address[] recipients) throws MessagingException {
        message.setFrom(null);
        InternetAddress[] address = new InternetAddress[1];
        try {
            address[0] = new InternetAddress(this.profile.address, this.profile.username, "ISO-2022-JP");
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException();
        }
        message.addFrom((Address[])address);
        message.setSentDate(new Date());
        message.setHeader("Content-Transfer-Encoding", "7bit");
        message.saveChanges();
        this.transport.sendMessage((Message)message, recipients);
    }
}

