/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.mail;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;

final class MailUtils {
    MailUtils() {
    }

    public static final InternetAddress createInternetAddress(String address) {
        return MailUtils.createInternetAddress(address, "");
    }

    public static final InternetAddress createInternetAddress(String address, String name) {
        try {
            return new InternetAddress(address, name, "ISO-2022-JP");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    static String getFirstPlainText(Part part) throws IOException, MessagingException {
        if (part.isMimeType("text/plain")) {
            return (String)part.getContent();
        }
        if (part.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)part.getContent();
            if (mp.getCount() > 0) {
                return MailUtils.getFirstPlainText((Part)mp.getBodyPart(0));
            }
            return null;
        }
        return null;
    }
}

