/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.vodafone;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.livez.CarrierType;
import jp.sourceforge.livez.Screen;
import jp.sourceforge.livez.ServiceType;
import jp.sourceforge.livez.images.ImageType;
import jp.sourceforge.livez.vodafone.Application;
import jp.sourceforge.livez.vodafone.ScreenImpl;
import jp.sourceforge.livez.vodafone.UID;
import jp.sourceforge.livez.vodafone.Vappli;
import jp.sourceforge.livez.vodafone.Vodafone;
import jp.sourceforge.livez.vodafone.VodafoneBrowser;
import jp.sourceforge.livez.vodafone.VodafoneBrowserImpl;
import jp.sourceforge.livez.vodafone.VodafoneCategoryType;
import jp.sourceforge.livez.vodafone.VodafoneRequest;
import jp.sourceforge.livez.vodafone.VodafoneSound;
import jp.sourceforge.livez.vodafone.VodafoneSoundImpl;
import jp.sourceforge.livez.vodafone.VodafoneType;
import jp.sourceforge.livez.vodafone.VodafoneUserAgent;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VodafoneImpl
implements Vodafone {
    private static final long serialVersionUID = 1L;
    private String id = null;
    private String name = null;
    private String productName = null;
    private String seriesName = null;
    private String vendorId = null;
    private ScreenImpl screen = null;
    private VodafoneBrowserImpl browser = null;
    private Vappli appli = null;
    private VodafoneSoundImpl sound = null;
    private VodafoneType type = null;
    private Application application = null;
    private String serialNumber = null;
    private UID uid = null;
    private List<ImageType> imageTypes = new ArrayList<ImageType>(4);

    public VodafoneImpl() {
        this.imageTypes.add(ImageType.PNG);
    }

    void setup(jp.sourceforge.livez.dao.Vodafone v) {
        this.name = v.getName();
        this.productName = v.getProductName();
    }

    void setup(VodafoneRequest r) {
        VodafoneUserAgent ua = r.getUserAgent();
        this.id = r.getId();
        this.name = r.getName();
        if (this.productName == null) {
            this.productName = r.getName();
        }
        this.seriesName = r.getSeriesName();
        this.vendorId = r.getVendorId();
        if (r.getType() != VodafoneType.UNKNOWN) {
            this.screen = new ScreenImpl(r);
            this.browser = new VodafoneBrowserImpl(r);
        }
        this.appli = ua.getVappli();
        if (r.getSmd() > 0 || r.getSmaf() != null) {
            this.sound = new VodafoneSoundImpl(r);
        }
        this.type = r.getType();
        this.application = ua.getApplication();
        this.serialNumber = ua.getSerialNumber();
        this.uid = r.getUID();
        if (r.getType() != VodafoneType.C2) {
            this.imageTypes.add(ImageType.JPEG);
        }
        if (r.getType() != VodafoneType.UNKNOWN || r.getType().getCategoryType() != VodafoneCategoryType.THREE_GC) {
            this.imageTypes.add(ImageType.GIF_8BIT);
        }
    }

    @Override
    public ServiceType getServiceType() {
        return ServiceType.VODAFONE_LIVE;
    }

    @Override
    public CarrierType getCarrierType() {
        return CarrierType.VODAFONE;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public String getSeriesName() {
        return this.seriesName;
    }

    @Override
    public String getVendorId() {
        return this.vendorId;
    }

    @Override
    public Screen getScreen() {
        return this.screen;
    }

    @Override
    public VodafoneBrowser getBrowser() {
        return this.browser;
    }

    @Override
    public Vappli getAppli() {
        return this.appli;
    }

    @Override
    public VodafoneSound getSound() {
        return this.sound;
    }

    @Override
    public VodafoneType getType() {
        return this.type;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public UID getUserId() {
        return this.uid;
    }

    @Override
    public List<ImageType> getEnableImageTypes() {
        return this.imageTypes;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

