/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freehep.application.Application;
import org.freehep.application.PropertyUtilities;

public final class RecentItemTextField
extends JComboBox
implements KeyListener {
    private int m_minWidth = -1;
    private int m_maxWidth = -1;
    private int m_nItems;
    private String[] m_dropDownItems;
    private String m_key = null;
    private JTextField m_textField;
    private ChangeEvent m_changeEvent = null;
    private Properties m_prop = null;
    private boolean m_clickDefault;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public RecentItemTextField(String[] dropDownItems, boolean clickDefault) {
        this.m_clickDefault = clickDefault;
        this.init(dropDownItems);
    }

    public RecentItemTextField(String key, int nItems, boolean clickDefault) {
        this.m_clickDefault = clickDefault;
        this.m_prop = Application.getApplication().getUserProperties();
        this.m_nItems = nItems;
        this.m_key = key;
        this.init(PropertyUtilities.getStringArray(this.m_prop, this.m_key, null));
    }

    public RecentItemTextField(String key, String lengthKey, boolean clickDefault) {
        this(key, PropertyUtilities.getInteger(Application.getApplication().getUserProperties(), lengthKey, 4), clickDefault);
    }

    private void init(String[] dropDownItems) {
        this.m_dropDownItems = dropDownItems;
        if (this.m_dropDownItems != null) {
            int i = 0;
            while (i < this.m_dropDownItems.length) {
                this.addItem(this.m_dropDownItems[i]);
                ++i;
            }
        }
        this.setEditable(true);
        this.m_textField = (JTextField)this.getEditor().getEditorComponent();
        this.m_textField.addKeyListener(this);
    }

    public void saveState() {
        if (this.m_key != null) {
            PropertyUtilities.setStringArray(this.m_prop, this.m_key, RecentItemTextField.updateStringArray(this.m_dropDownItems, this.getText(), this.m_nItems));
        }
    }

    public String getText() {
        return this.m_textField.getText();
    }

    public void setText(String s) {
        if (s.equals(this.getItemAt(0))) {
            return;
        }
        this.removeItem(s);
        this.insertItemAt(s, 0);
        this.setSelectedIndex(0);
    }

    public void addKeyListener(KeyListener kl) {
        if (this.m_textField != null) {
            this.m_textField.addKeyListener(kl);
        }
    }

    public final void keyReleased(KeyEvent e) {
    }

    public final void keyPressed(KeyEvent e) {
        JButton b;
        if (e.getSource() != this.m_textField) {
            return;
        }
        this.fireStateChanged();
        if (e.getKeyCode() == 10 && this.m_clickDefault && (b = this.getRootPane().getDefaultButton()) != null) {
            b.doClick();
        }
    }

    private void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$javax$swing$event$ChangeListener == null ? RecentItemTextField.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                if (this.m_changeEvent == null) {
                    this.m_changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.m_changeEvent);
            }
            i -= 2;
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = RecentItemTextField.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    public void addActionListener(ActionListener l) {
        this.m_textField.addActionListener(l);
    }

    protected final void fireItemStateChanged(ItemEvent event) {
        super.fireItemStateChanged(event);
        this.fireStateChanged();
    }

    public final void requestFocus() {
        this.m_textField.requestFocus();
    }

    public final void keyTyped(KeyEvent e) {
    }

    public final void setMaxWidth(int maxWidth) {
        this.m_maxWidth = maxWidth;
    }

    public final void setMinWidth(int minWidth) {
        this.m_minWidth = minWidth;
    }

    public final Dimension getMaximumSize() {
        Dimension d = super.getMaximumSize();
        if (this.m_maxWidth > 0 && this.m_maxWidth < d.width) {
            d.width = this.m_maxWidth;
        }
        return d;
    }

    public final Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        if (this.m_minWidth > 0 && this.m_minWidth > d.width) {
            d.width = this.m_minWidth;
        }
        return d;
    }

    public final Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.m_minWidth > 0 && this.m_minWidth > d.width) {
            d.width = this.m_minWidth;
        }
        if (this.m_maxWidth > 0 && this.m_maxWidth < d.width) {
            d.width = this.m_maxWidth;
        }
        return d;
    }

    public static String showInputDialog(Component owner, Object message, String key) {
        return RecentItemTextField.showInputDialog(owner, message, "Input", 3, key);
    }

    public static String showInputDialog(Component owner, Object message, String title, int messageType, String key) {
        RecentItemTextField field = new RecentItemTextField(key, 4, true);
        JPanel mpanel = new JPanel(new BorderLayout());
        if (message instanceof Component) {
            mpanel.add((JComponent)message);
        } else {
            mpanel.add(new JLabel(message.toString()));
        }
        mpanel.add((Component)field, "South");
        int rc = JOptionPane.showOptionDialog(owner, mpanel, title, 2, messageType, null, null, null);
        if (rc == 0) {
            field.saveState();
            return field.getText();
        }
        return null;
    }

    private static String[] updateStringArray(String[] oldArray, String newString, int nStored) {
        if (newString == null) {
            return oldArray;
        }
        if (oldArray != null && oldArray.length > 0) {
            if (oldArray[0].equals(newString)) {
                return oldArray;
            }
            int i = 1;
            while (i < oldArray.length) {
                if (oldArray[i].equals(newString)) {
                    while (i > 0) {
                        oldArray[i] = oldArray[i - 1];
                        --i;
                    }
                    oldArray[0] = newString;
                    return oldArray;
                }
                ++i;
            }
            if (oldArray.length < nStored) {
                String[] result = new String[oldArray.length + 1];
                result[0] = newString;
                int i2 = 0;
                while (i2 < oldArray.length) {
                    result[i2 + 1] = oldArray[i2];
                    ++i2;
                }
                return result;
            }
            int i3 = nStored - 1;
            while (i3 > 0) {
                oldArray[i3] = oldArray[i3 - 1];
                --i3;
            }
            oldArray[0] = newString;
            return oldArray;
        }
        oldArray = new String[]{newString};
        return oldArray;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

