/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.mdi;

import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import org.freehep.application.Application;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.mdi.InternalFramePageManager;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.application.mdi.PageManager;
import org.freehep.application.mdi.TabbedPageManager;
import org.freehep.application.mdi.ToolBarHolder;
import org.freehep.util.commanddispatcher.BooleanCommandState;
import org.freehep.util.commanddispatcher.CommandProcessor;

public class MDIApplication
extends Application {
    public static final int TOOLBAR_DEFAULT = 0;
    public static final int TOOLBAR_INVISIBLE = 1;
    public static final int TOOLBAR_VISIBLE = 2;
    public static final int TOOLBAR_AUTO = 3;
    public static final int TOOLBAR_PROGRAM = 4;
    private PageListener pageListener = new MDIPageListener();
    private PageManager pageManager;
    private PageManager controlManager;
    private PageManager consoleManager;
    private JSplitPane consoleSplit;
    private JSplitPane controlSplit;
    private ToolBarHolder mdiToolBarHolder;
    static /* synthetic */ Class class$org$freehep$application$mdi$MDIApplication;

    public MDIApplication(String appName) {
        super(appName);
        this.add(this.getPageManager().getEmbodiment());
    }

    protected void loadDefaultProperties(Properties app) throws IOException {
        super.loadDefaultProperties(app);
        InputStream in = (class$org$freehep$application$mdi$MDIApplication == null ? (class$org$freehep$application$mdi$MDIApplication = MDIApplication.class$("org.freehep.application.mdi.MDIApplication")) : class$org$freehep$application$mdi$MDIApplication).getResourceAsStream("MDIDefault.properties");
        app.load(in);
        in.close();
    }

    protected void saveUserProperties() {
        Properties user = this.getUserProperties();
        if (this.consoleSplit != null) {
            PropertyUtilities.setInteger(user, "consoleDividerLocation", this.consoleSplit.getDividerLocation());
        }
        if (this.controlSplit != null) {
            PropertyUtilities.setInteger(user, "controlDividerLocation", this.controlSplit.getDividerLocation());
        }
        if (this.mdiToolBarHolder != null) {
            this.mdiToolBarHolder.save(user);
        }
        super.saveUserProperties();
    }

    public void addToolBar(JToolBar toolBar, String name, int mode) {
        if (this.mdiToolBarHolder == null) {
            this.mdiToolBarHolder = new ToolBarHolder();
            this.getToolBarHolder().add((Component)this.mdiToolBarHolder, "North");
        }
        if (mode == 0) {
            mode = PropertyUtilities.getInteger(this.getUserProperties(), "ToolBar." + name, mode);
        }
        this.mdiToolBarHolder.add(toolBar, name, mode);
    }

    public void addToolBar(JToolBar toolBar, String name) {
        this.addToolBar(toolBar, name, 0);
    }

    public void removeToolBar(JToolBar toolBar) {
        this.mdiToolBarHolder.remove(toolBar);
    }

    public PageManager getPageManager() {
        if (this.pageManager == null) {
            this.setPageManager(this.createPageManager());
        }
        return this.pageManager;
    }

    public void setPageManager(PageManager manager) {
        if (this.pageManager != null) {
            this.getCommandTargetManager().remove(this.pageManager.getCommandProcessor());
        }
        this.switchPageManager(this.pageManager, manager);
        this.getCommandTargetManager().add(manager.getCommandProcessor());
        if (this.pageManager != null) {
            Container parent = this.pageManager.getEmbodiment().getParent();
            int index = 0;
            int i = 0;
            while (i < parent.getComponentCount()) {
                if (parent.getComponent(i) == this.pageManager.getEmbodiment()) {
                    index = i;
                    break;
                }
                ++i;
            }
            parent.remove(index);
            parent.add(manager.getEmbodiment(), index);
            parent.validate();
            this.getCommandProcessor().setChanged();
        }
        this.pageManager = manager;
    }

    public PageManager getControlManager() {
        if (this.controlManager == null) {
            this.setControlManager(this.createControlManager());
        }
        return this.controlManager;
    }

    public void setControlManager(PageManager manager) {
        this.switchPageManager(this.controlManager, manager);
        this.controlManager = manager;
    }

    public PageManager getConsoleManager() {
        if (this.consoleManager == null) {
            this.setConsoleManager(this.createConsoleManager());
        }
        return this.consoleManager;
    }

    public void setConsoleManager(PageManager manager) {
        this.switchPageManager(this.consoleManager, manager);
        this.consoleManager = manager;
    }

    protected PageManager createPageManager() {
        return this.createManager("pageManager");
    }

    protected PageManager createControlManager() {
        return this.createManager("controlManager");
    }

    protected PageManager createConsoleManager() {
        return this.createManager("consoleManager");
    }

    protected PageManager createManager(String type) {
        try {
            Class<?> k = Class.forName(this.getUserProperties().getProperty(type));
            return (PageManager)k.newInstance();
        }
        catch (Exception x) {
            throw new Application.InitializationException("Could not create PageManager: " + type, x);
        }
    }

    private void switchPageManager(PageManager oldManager, PageManager newManager) {
        if (oldManager != null) {
            oldManager.removePageListener(this.pageListener);
            List l = oldManager.pages();
            newManager.addPageListener(this.pageListener);
            newManager.init(l, oldManager.getSelectedPage());
        } else {
            newManager.addPageListener(this.pageListener);
        }
    }

    private void showControl(boolean show) {
        if (show && this.controlSplit == null) {
            Component pages = this.pageManager.getEmbodiment();
            Container parent = pages.getParent();
            parent.remove(pages);
            this.controlSplit = new JSplitPane(1, this.controlManager.getEmbodiment(), pages);
            int pixels = PropertyUtilities.getInteger(this.getUserProperties(), "controlDividerLocation", -1);
            if (pixels > 0) {
                this.controlSplit.setDividerLocation(pixels);
            }
            parent.add(this.controlSplit);
            this.revalidate();
        } else if (!show && this.controlSplit != null) {
            PropertyUtilities.setInteger(this.getUserProperties(), "controlDividerLocation", this.controlSplit.getDividerLocation());
            Component pages = this.pageManager.getEmbodiment();
            Container parent = this.controlSplit.getParent();
            parent.remove(this.controlSplit);
            this.controlSplit = null;
            parent.add(pages);
            this.revalidate();
        }
    }

    private void showConsole(boolean show) {
        if (show && this.consoleSplit == null) {
            Component old = this.getComponent(0);
            this.remove(old);
            this.consoleSplit = new JSplitPane(0, old, this.consoleManager.getEmbodiment());
            int pixels = PropertyUtilities.getInteger(this.getUserProperties(), "consoleDividerLocation", -1);
            if (pixels > 0) {
                this.consoleSplit.setDividerLocation(pixels);
            }
            this.add(this.consoleSplit);
            this.revalidate();
        } else if (!show && this.consoleSplit != null) {
            PropertyUtilities.setInteger(this.getUserProperties(), "consoleDividerLocation", this.consoleSplit.getDividerLocation());
            Component old = this.consoleSplit.getTopComponent();
            this.remove(this.consoleSplit);
            this.consoleSplit = null;
            this.add(old);
            this.revalidate();
        }
    }

    protected CommandProcessor createCommandProcessor() {
        return new MDICommandProcessor();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class MDICommandProcessor
    extends Application.ApplicationCommandProcessor {
        public MDICommandProcessor() {
            super(MDIApplication.this);
        }

        public void onTabbedPanes(boolean state) {
            if (state) {
                MDIApplication.this.setPageManager(new TabbedPageManager());
                MDIApplication.this.getUserProperties().setProperty("pageManager", MDIApplication.this.getPageManager().getClass().getName());
            }
        }

        public void enableTabbedPanes(BooleanCommandState state) {
            state.setEnabled(true);
            state.setSelected(MDIApplication.this.getPageManager() instanceof TabbedPageManager);
        }

        public void onInternalFrames(boolean state) {
            if (state) {
                MDIApplication.this.setPageManager(new InternalFramePageManager());
                MDIApplication.this.getUserProperties().setProperty("pageManager", MDIApplication.this.getPageManager().getClass().getName());
            }
        }

        public void enableInternalFrames(BooleanCommandState state) {
            state.setEnabled(true);
            state.setSelected(MDIApplication.this.getPageManager() instanceof InternalFramePageManager);
        }
    }

    private class MDIPageListener
    implements PageListener {
        private MDIPageListener() {
        }

        public void pageChanged(PageEvent event) {
            PageManager manager;
            int id = event.getID();
            if (id == 4004) {
                PageManager manager2 = event.getPageContext().getPageManager();
                if (manager2.getPageCount() == 1) {
                    if (manager2 == MDIApplication.this.controlManager) {
                        MDIApplication.this.showControl(true);
                    }
                    if (manager2 == MDIApplication.this.consoleManager) {
                        MDIApplication.this.showConsole(true);
                    }
                }
            } else if (id == 4001 && (manager = event.getPageContext().getPageManager()).getPageCount() == 0) {
                if (manager == MDIApplication.this.controlManager) {
                    MDIApplication.this.showControl(false);
                }
                if (manager == MDIApplication.this.consoleManager) {
                    MDIApplication.this.showConsole(false);
                }
            }
        }
    }
}

