/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import org.freehep.util.io.FinishableOutputStream;

public class CompressableOutputStream
extends FilterOutputStream
implements FinishableOutputStream {
    private boolean compress = false;
    private DeflaterOutputStream dos;

    public CompressableOutputStream(OutputStream out) {
        super(out);
    }

    public void write(int b) throws IOException {
        if (this.compress) {
            this.dos.write(b);
        } else {
            this.out.write(b);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.write(b[off + i]);
            ++i;
        }
    }

    public void finish() throws IOException {
        if (this.compress) {
            this.dos.finish();
        }
        if (this.out instanceof FinishableOutputStream) {
            ((FinishableOutputStream)((Object)this.out)).finish();
        }
    }

    public void close() throws IOException {
        if (this.compress) {
            this.finish();
            this.dos.close();
        } else {
            this.out.close();
        }
    }

    public void startCompressing() throws IOException {
        this.out.flush();
        this.compress = true;
        this.dos = new DeflaterOutputStream(this.out);
    }
}

