/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.xml.io;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.freehep.xml.io.DefaultXMLIORegistry;
import org.freehep.xml.io.XMLIO;
import org.freehep.xml.io.XMLIOFactory;
import org.freehep.xml.io.XMLIOFileManager;
import org.freehep.xml.io.XMLIOProxy;
import org.freehep.xml.io.XMLIORegistry;
import org.freehep.xml.io.XMLIOStreamManager;
import org.jdom.Element;
import org.jdom.JDOMException;

public class XMLIOManager {
    private Hashtable objIdHash = new Hashtable();
    private Hashtable idHash = new Hashtable();
    private Hashtable nodeHash = new Hashtable();
    private Hashtable classHash = new Hashtable();
    private Hashtable refTable = new Hashtable();
    private XMLIORegistry xmlioRegistry;
    private XMLIOStreamManager xmlioStreamManager;
    private boolean useId = true;

    private XMLIOManager() {
        this(new DefaultXMLIORegistry(), new XMLIOFileManager("defaultXMLIOFile.xml"), true);
    }

    public XMLIOManager(String fileName) {
        this(new DefaultXMLIORegistry(), new XMLIOFileManager(fileName), true);
    }

    private XMLIOManager(boolean useId) {
        this(new DefaultXMLIORegistry(), new XMLIOFileManager("defaultXMLIOFile.xml"), useId);
    }

    private XMLIOManager(XMLIORegistry xmlioRegistry, XMLIOStreamManager xmlioFileManager) {
        this(xmlioRegistry, xmlioFileManager, true);
    }

    private XMLIOManager(XMLIORegistry xmlioRegistry, XMLIOStreamManager xmlioFileManager, boolean useId) {
        this.setXMLIORegistry(xmlioRegistry);
        this.setXMLIOStreamManager(xmlioFileManager);
        this.useId = useId;
    }

    protected void setXMLIORegistry(XMLIORegistry xmlioRegistry) {
        this.xmlioRegistry = xmlioRegistry;
    }

    public XMLIORegistry getXMLIORegistry() {
        return this.xmlioRegistry;
    }

    public void setXMLIOStreamManager(XMLIOStreamManager xmlioStreamManager) {
        this.xmlioStreamManager = xmlioStreamManager;
    }

    public XMLIOStreamManager getXMLIOStreamManager() {
        return this.xmlioStreamManager;
    }

    public Object restore(Element nodeEl) {
        String objIdRef = nodeEl.getAttributeValue("objIdRef");
        if (objIdRef != null && this.useId) {
            if (this.isObjIdRegistered(objIdRef)) {
                return this.getObj(objIdRef);
            }
            return this.restore((Element)this.refTable.get(objIdRef));
        }
        String objId = nodeEl.getAttributeValue("objId");
        if (this.useId && this.isObjIdRegistered(objId)) {
            return this.getObj(objId);
        }
        Class objClass = this.classHash.containsKey(nodeEl.getName()) ? (Class)this.classHash.get(nodeEl.getName()) : this.xmlioRegistry.getIdClass(nodeEl.getName());
        Object xmlio = this.getXMLIOFactory(objClass).createObject(objClass);
        if (this.useId) {
            this.registerObj(xmlio, objId);
        }
        if (xmlio instanceof XMLIO) {
            ((XMLIO)xmlio).restore(this, nodeEl);
        } else {
            this.getXMLIOProxy(objClass).restore(xmlio, this, nodeEl);
        }
        return xmlio;
    }

    public Element saveAs(Object obj, Class clazz) {
        String nodeName = this.nodeHash.containsKey(clazz) ? (String)this.nodeHash.get(clazz) : this.xmlioRegistry.getClassId(clazz);
        Element el = new Element(nodeName);
        if (this.isObjRegistered(obj)) {
            el.setAttribute("objIdRef", this.getObjId(obj));
        } else {
            if (this.useId) {
                el.setAttribute("objId", this.registerObj(obj));
            }
            if (obj instanceof XMLIO) {
                ((XMLIO)obj).save(this, el);
            } else {
                this.getXMLIOProxy(clazz).save(obj, this, el);
            }
        }
        return el;
    }

    public Element save(Object obj) {
        return this.saveAs(obj, obj.getClass());
    }

    public void saveToXML(Object[] objs, Element nodeEl) {
        this.resetObjId();
        int i = 0;
        while (i < objs.length) {
            nodeEl.addContent(this.save(objs[i]));
            ++i;
        }
        try {
            this.xmlioStreamManager.saveRootElement(nodeEl);
        }
        catch (IOException ioe) {
            System.out.println(" Problem with file " + ioe.getMessage());
        }
    }

    public Object[] restoreFromXML() {
        this.resetObjId();
        Object[] objs = null;
        try {
            Element restoreElement = this.xmlioStreamManager.getRootElement();
            List children = restoreElement.getChildren();
            Iterator it = children.iterator();
            while (it.hasNext()) {
                this.loadRefTable((Element)it.next());
            }
            objs = new Object[children.size()];
            int child = 0;
            Iterator it2 = children.iterator();
            while (it2.hasNext()) {
                objs[child++] = this.restore((Element)it2.next());
            }
        }
        catch (JDOMException je) {
            System.out.println(" Problem with restoring " + je.getMessage());
        }
        catch (IOException ioe) {
            System.out.println(" Problem with file " + ioe.getMessage());
        }
        return objs;
    }

    public void setClassId(Class clName, String id) {
        this.nodeHash.put(clName, id);
        this.classHash.put(id, clName);
    }

    protected void loadRefTable(Element el) {
        String objId = el.getAttributeValue("objId");
        if (objId != null) {
            this.refTable.put(objId, el);
        }
        List children = el.getChildren();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            this.loadRefTable((Element)it.next());
        }
    }

    private String makeObjId(Object obj) {
        String clName = obj.getClass().getName();
        String pkgName = obj.getClass().getPackage().getName();
        String idName = clName.substring(pkgName.length() + 1, clName.length()).trim();
        while (idName.indexOf(36) != -1) {
            idName = idName.substring(idName.indexOf(36) + 1, idName.length()).trim();
        }
        int i = 1;
        if (this.idHash.containsKey(idName)) {
            i = (Integer)this.idHash.get(idName) + 1;
        }
        this.idHash.put(idName, new Integer(i));
        String objId = idName + i;
        return objId;
    }

    private String registerObj(Object obj) {
        if (this.objIdHash.contains(obj)) {
            return this.getObjId(obj);
        }
        String objId = this.makeObjId(obj);
        this.objIdHash.put(objId, obj);
        return objId;
    }

    private void registerObj(Object obj, String objId) {
        if (this.objIdHash.containsKey(objId)) {
            return;
        }
        this.objIdHash.put(objId, obj);
    }

    private String getObjId(Object obj) {
        Enumeration keys = this.objIdHash.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!this.objIdHash.get(key).equals(obj)) continue;
            return key;
        }
        return (String)obj;
    }

    private Object getObj(String objId) {
        if (this.objIdHash.containsKey(objId)) {
            return this.objIdHash.get(objId);
        }
        return objId;
    }

    private boolean isObjRegistered(Object obj) {
        return this.objIdHash.contains(obj);
    }

    private boolean isObjIdRegistered(String objId) {
        return this.objIdHash.containsKey(objId);
    }

    public void resetObjId() {
        this.objIdHash.clear();
        this.idHash.clear();
        this.refTable.clear();
    }

    protected XMLIOFactory getXMLIOFactory(Class objClass) {
        return this.xmlioRegistry.getXMLIOFactory(objClass);
    }

    protected XMLIOProxy getXMLIOProxy(Class objClass) {
        return this.xmlioRegistry.getXMLIOProxy(objClass);
    }
}

