/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.cache;

import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.engine.cache.CacheController;
import com.ibatis.sqlmap.engine.cache.CacheKey;
import com.ibatis.sqlmap.engine.mapping.statement.ExecuteListener;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class CacheModel
implements ExecuteListener {
    public static final Object NULL_OBJECT = new Object();
    private int requests = 0;
    private int hits = 0;
    private static final long NO_FLUSH_INTERVAL = -99999L;
    private String id;
    private boolean readOnly;
    private boolean serialize;
    private long lastFlush = System.currentTimeMillis();
    private long flushInterval = -99999L;
    private long flushIntervalSeconds = -99999L;
    private Set flushTriggerStatements = new HashSet();
    private CacheController controller;
    private String resource;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isSerialize() {
        return this.serialize;
    }

    public void setSerialize(boolean serialize) {
        this.serialize = serialize;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setControllerClassName(String implementation) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class clazz = Resources.classForName((String)implementation);
        this.controller = (CacheController)Resources.instantiate((Class)clazz);
    }

    public long getFlushInterval() {
        return this.flushInterval;
    }

    public long getFlushIntervalSeconds() {
        return this.flushIntervalSeconds;
    }

    public void setFlushInterval(long flushInterval) {
        this.flushInterval = flushInterval;
        this.flushIntervalSeconds = flushInterval / 1000L;
    }

    public void addFlushTriggerStatement(String statementName) {
        this.flushTriggerStatements.add(statementName);
    }

    public Iterator getFlushTriggerStatementNames() {
        return this.flushTriggerStatements.iterator();
    }

    public void onExecuteStatement(MappedStatement statement) {
        this.flush();
    }

    public double getHitRatio() {
        return (double)this.hits / (double)this.requests;
    }

    public void configure(Properties props) {
        this.controller.configure(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        CacheModel cacheModel = this;
        synchronized (cacheModel) {
            this.controller.flush(this);
            this.lastFlush = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(CacheKey key) {
        Object value = null;
        CacheModel cacheModel = this;
        synchronized (cacheModel) {
            if (this.flushInterval != -99999L && System.currentTimeMillis() - this.lastFlush > this.flushInterval) {
                this.flush();
            }
            value = this.controller.getObject(this, key);
            if (this.serialize && !this.readOnly && value != NULL_OBJECT && value != null) {
                try {
                    ByteArrayInputStream bis = new ByteArrayInputStream((byte[])value);
                    ObjectInputStream ois = new ObjectInputStream(bis);
                    value = ois.readObject();
                    ois.close();
                }
                catch (Exception e) {
                    throw new NestedRuntimeException("Error caching serializable object.  Be sure you're not attempting to use a serialized cache for an object that may be taking advantage of lazy loading.  Cause: " + e, (Throwable)e);
                }
            }
            ++this.requests;
            if (value != null) {
                ++this.hits;
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putObject(CacheKey key, Object value) {
        if (null == value) {
            value = NULL_OBJECT;
        }
        CacheModel cacheModel = this;
        synchronized (cacheModel) {
            if (this.serialize && !this.readOnly && value != NULL_OBJECT) {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(value);
                    oos.flush();
                    oos.close();
                    value = bos.toByteArray();
                }
                catch (IOException e) {
                    throw new NestedRuntimeException("Error caching serializable object.  Cause: " + e, (Throwable)e);
                }
            }
            this.controller.putObject(this, key, value);
        }
    }
}

