/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapper;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class Canonicalizer {
    public Map buildCanonicalMap(String[] originals) {
        return this.buildCanonicalMap(originals, null);
    }

    public Map buildCanonicalMap(String[] originals, String parentName) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < originals.length; ++i) {
            map.put(originals[i], originals[i]);
        }
        this.upperCase(map);
        this.removeUnderscores(map);
        this.removePKFK(map);
        this.removePrefixes(map);
        this.removeSuffixes(map);
        this.removePluralization(map);
        this.removeParentName(map, parentName);
        return map;
    }

    private void removeParentName(Map map, String parentName) {
        if (parentName != null) {
            parentName = parentName.toUpperCase();
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                String original = (String)i.next();
                String canonical = (String)map.get(original);
                if (canonical.startsWith(parentName)) {
                    map.put(original, canonical.substring(parentName.length()));
                }
                if (!canonical.endsWith(parentName)) continue;
                map.put(original, canonical.substring(0, canonical.length() - parentName.length()));
            }
        }
    }

    private void upperCase(Map map) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String original = (String)i.next();
            String canonical = (String)map.get(original);
            map.put(original, canonical.toUpperCase());
        }
    }

    private void removePKFK(Map map) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String original = (String)i.next();
            String canonical = (String)map.get(original);
            if (canonical.startsWith("PK")) {
                map.put(original, canonical.substring(2));
            } else if (canonical.startsWith("FK")) {
                map.put(original, canonical.substring(2));
            }
            if (canonical.endsWith("PK")) {
                map.put(original, canonical.substring(0, canonical.length() - 2));
                continue;
            }
            if (!canonical.endsWith("FK")) continue;
            map.put(original, canonical.substring(0, canonical.length() - 2));
        }
    }

    private void removePrefixes(Map map) {
        int prefix = this.findPrefixLength(map);
        if (prefix > 1) {
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                String original = (String)i.next();
                String canonical = (String)map.get(original);
                map.put(original, canonical.substring(prefix));
            }
        }
    }

    private void removeSuffixes(Map map) {
        int suffix = this.findSuffixLength(map);
        if (suffix > 1) {
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                String original = (String)i.next();
                String canonical = (String)map.get(original);
                map.put(original, canonical.substring(0, canonical.length() - suffix));
            }
        }
    }

    private int findPrefixLength(Map map) {
        String[] originals = map.keySet().toArray(new String[map.keySet().size()]);
        char[] samples = ((String)map.get(this.findShortestString(originals))).toCharArray();
        int prefix = 0;
        for (int i = 0; i < samples.length; ++i) {
            for (int j = 0; j < originals.length; ++j) {
                String original = originals[j];
                String canonical = (String)map.get(original);
                if (canonical.charAt(prefix) == samples[i]) continue;
                return prefix;
            }
            ++prefix;
        }
        if (prefix == samples.length) {
            prefix = 0;
        }
        return prefix;
    }

    private int findSuffixLength(Map map) {
        String[] originals = map.keySet().toArray(new String[map.keySet().size()]);
        char[] samples = ((String)map.get(this.findShortestString(originals))).toCharArray();
        int suffix = 0;
        for (int i = 0; i < samples.length; ++i) {
            for (int j = 0; j < originals.length; ++j) {
                String original = originals[j];
                String canonical = (String)map.get(original);
                if (canonical.charAt(canonical.length() - suffix - 1) == samples[samples.length - i - 1]) continue;
                return suffix;
            }
            ++suffix;
        }
        if (suffix == samples.length) {
            suffix = 0;
        }
        return suffix;
    }

    private String findShortestString(String[] originals) {
        String shortest = originals[0];
        for (int i = 0; i < originals.length; ++i) {
            if (originals[i].length() >= shortest.length()) continue;
            shortest = originals[i];
        }
        return shortest;
    }

    private void removeUnderscores(Map map) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String original = (String)i.next();
            String canonical = (String)map.get(original);
            map.put(original, this.removeUnderscoresFromString(canonical));
        }
    }

    private void removePluralization(Map map) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String original = (String)i.next();
            String canonical = (String)map.get(original);
            if (!canonical.endsWith("S") && !canonical.endsWith("s")) continue;
            map.put(original, canonical.substring(0, canonical.length() - 1));
        }
    }

    private String removeUnderscoresFromString(String original) {
        StringBuffer canonical = new StringBuffer();
        StringTokenizer parser = new StringTokenizer(original, "_", false);
        while (parser.hasMoreTokens()) {
            canonical.append(parser.nextToken());
        }
        return canonical.toString();
    }
}

