/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.awt.Component;
import java.awt.Graphics;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.MultiPageDocument;
import org.freehep.graphicsio.exportchooser.Options;
import org.freehep.graphicsio.exportchooser.ProgressDialog;
import org.freehep.util.export.ExportFileType;

public abstract class AbstractExportFileType
extends ExportFileType {
    public VectorGraphics getGraphics(File file, Component target) throws IOException {
        return this.getGraphics(new BufferedOutputStream(new FileOutputStream(file)), target);
    }

    public abstract VectorGraphics getGraphics(OutputStream var1, Component var2) throws IOException;

    public void exportToFile(OutputStream os, Component target, Component parent, Properties properties, String creator) throws IOException {
        VectorGraphics g = this.getGraphics(os, target);
        if (g != null) {
            g.setCreator(creator);
            g.setProperties(properties);
            g.startExport();
            target.print((Graphics)g);
            g.endExport();
        }
    }

    public void exportToFile(File file, Component target, Component parent, Properties properties, String creator) throws IOException {
        VectorGraphics g = this.getGraphics(file, target);
        if (g != null) {
            g.setCreator(creator);
            g.setProperties(properties);
            g.startExport();
            target.print((Graphics)g);
            g.endExport();
        }
    }

    public void exportToFile(OutputStream os, Component[] targets, Component parent, Properties properties, String creator) throws IOException {
        ProgressDialog progress = null;
        MultiPageSingleFileExportThread exportThread = null;
        VectorGraphics g = this.getGraphics(os, targets[0]);
        if (g != null && g instanceof MultiPageDocument) {
            g.setCreator(creator);
            g.setProperties(properties);
            g.startExport();
            progress = new ProgressDialog(parent, targets.length * 3 + 2, "Writing header...");
            MultiPageDocument mdoc = (MultiPageDocument)g;
            mdoc.setMultiPage(true);
            exportThread = new MultiPageSingleFileExportThread(mdoc, g, targets, progress, os);
            exportThread.start();
            progress.show();
            IOException exc = progress.getException();
            if (exc != null) {
                throw exc;
            }
        } else {
            System.out.println("Cannot write multi files to one output stream.");
        }
    }

    public void exportToFile(File file, Component[] targets, Component parent, Properties properties, String creator) throws IOException {
        ProgressDialog progress = null;
        CancelThread exportThread = null;
        VectorGraphics g = this.getGraphics(file, targets[0]);
        if (g != null && g instanceof MultiPageDocument) {
            g.setCreator(creator);
            g.setProperties(properties);
            g.startExport();
            progress = new ProgressDialog(parent, targets.length * 3 + 2, "Writing header...");
            MultiPageDocument mdoc = (MultiPageDocument)g;
            mdoc.setMultiPage(true);
            exportThread = new MultiPageSingleFileExportThread(mdoc, g, targets, progress, file);
        } else {
            progress = new ProgressDialog(parent, targets.length + 2, "Exporting files...");
            exportThread = new MultipageMultipleFilesExportThread(targets, file, progress, parent, properties, creator);
        }
        exportThread.start();
        progress.show();
        IOException e = progress.getException();
        if (e != null) {
            throw e;
        }
    }

    public boolean applyChangedOptions(JPanel panel, Properties options) {
        if (panel instanceof Options) {
            return ((Options)((Object)panel)).applyChangedOptions(options);
        }
        System.err.println(((Object)((Object)this)).getClass() + ": applyChangedOptions(...), panel does not implement Options interface.");
        return false;
    }

    private class MultipageMultipleFilesExportThread
    extends CancelThread {
        private File file;
        private Component[] saveTargets;
        private Component parent;
        private Properties properties;
        private String creator;

        private MultipageMultipleFilesExportThread(Component[] saveTargets, File file, ProgressDialog progress, Component parent, Properties properties, String creator) {
            super(progress);
            this.file = file;
            this.saveTargets = saveTargets;
            this.parent = parent;
            this.properties = properties;
            this.creator = creator;
        }

        void export() throws IOException {
            int i = 0;
            while (i < this.saveTargets.length) {
                if (this.isStopped()) {
                    this.cleanUp();
                    return;
                }
                this.progress.step("Page " + (i + 1) + "/" + this.saveTargets.length + "...");
                String filename = this.file.getAbsolutePath();
                int dotIndex = filename.lastIndexOf(".");
                if (dotIndex == -1) {
                    dotIndex = filename.length() - 1;
                }
                filename = filename.substring(0, dotIndex) + "-" + (i + 1) + filename.substring(dotIndex);
                File singleFile = new File(filename);
                this.setCurrentFile(singleFile);
                AbstractExportFileType.this.exportToFile(singleFile, this.saveTargets[i], this.parent, this.properties, this.creator);
                this.setCurrentFile(null);
                ++i;
            }
            this.progress.dispose();
        }
    }

    private class MultiPageSingleFileExportThread
    extends CancelThread {
        private MultiPageDocument mdoc;
        private VectorGraphics graphics;
        private Component[] saveTargets;

        private MultiPageSingleFileExportThread(MultiPageDocument mdoc, VectorGraphics g, Component[] saveTargets, ProgressDialog progress) {
            super(progress);
            this.mdoc = mdoc;
            this.graphics = g;
            this.saveTargets = saveTargets;
            this.progress = progress;
        }

        private MultiPageSingleFileExportThread(MultiPageDocument mdoc, VectorGraphics g, Component[] saveTargets, ProgressDialog progress, OutputStream out) {
            this(mdoc, g, saveTargets, progress);
            this.setCurrentOutputStream(out);
        }

        private MultiPageSingleFileExportThread(MultiPageDocument mdoc, VectorGraphics g, Component[] saveTargets, ProgressDialog progress, File file) {
            this(mdoc, g, saveTargets, progress);
            this.setCurrentFile(file);
        }

        void export() throws IOException {
            this.graphics.startExport();
            int i = 0;
            while (i < this.saveTargets.length) {
                if (this.isStopped()) {
                    return;
                }
                if (this.graphics != null && this.mdoc != null) {
                    this.progress.step("Writing page " + (i + 1) + "/" + this.saveTargets.length + ".");
                    this.mdoc.openPage(this.saveTargets[i]);
                    if (this.isStopped()) {
                        return;
                    }
                    this.progress.step("Writing page " + (i + 1) + "/" + this.saveTargets.length + "..");
                    this.saveTargets[i].print((Graphics)this.graphics);
                    if (this.isStopped()) {
                        return;
                    }
                    this.progress.step("Writing page " + (i + 1) + "/" + this.saveTargets.length + "...");
                    this.mdoc.closePage();
                    if (this.isStopped()) {
                        return;
                    }
                }
                ++i;
            }
            if (this.isStopped()) {
                return;
            }
            this.progress.step("Writing trailer...");
            this.graphics.endExport();
            this.setCurrentOutputStream(null);
            this.setCurrentFile(null);
            this.progress.dispose();
        }
    }

    public abstract class CancelThread
    extends Thread {
        private boolean stop;
        private File currentFile;
        private OutputStream currentOut;
        ProgressDialog progress;

        private CancelThread(ProgressDialog progress) {
            this.progress = progress;
            this.stop = false;
            progress.interruptOnCancel(this);
        }

        abstract void export() throws IOException;

        public void cancel() {
            this.stop = true;
        }

        public boolean isStopped() {
            return this.stop;
        }

        public void run() {
            block4: {
                try {
                    this.export();
                }
                catch (IOException e) {
                    if (this.stop) break block4;
                    this.progress.exceptionOccured(e);
                }
            }
            try {
                this.cleanUp();
            }
            catch (IOException e) {
                System.err.println("While cleaning up:");
                e.printStackTrace();
            }
        }

        void setCurrentFile(File file) {
            this.currentFile = file;
        }

        void setCurrentOutputStream(OutputStream out) {
            this.currentOut = out;
        }

        void cleanUp() throws IOException {
            if (this.currentOut != null) {
                this.currentOut.close();
            }
            if (this.currentFile != null) {
                this.currentFile.delete();
            }
        }
    }
}

