/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.freehep.graphicsio.font.truetype.TTFFileInput;
import org.freehep.graphicsio.font.truetype.TTFFont;

public class TTFFile
extends TTFFont {
    private static final String mode = "r";
    private String fileName;
    private RandomAccessFile ttf;
    private int sfntMajorVersion;
    private int sfntMinorVersion;
    private int numberOfTables;
    private int searchRange;
    private int entrySelector;
    private int rangeShift;

    public TTFFile(String name) throws FileNotFoundException, IOException {
        this.fileName = name;
        this.ttf = new RandomAccessFile(name, mode);
        this.ttf.seek(0L);
        this.sfntMajorVersion = this.ttf.readUnsignedShort();
        this.sfntMinorVersion = this.ttf.readUnsignedShort();
        this.numberOfTables = this.ttf.readUnsignedShort();
        this.searchRange = this.ttf.readUnsignedShort();
        this.entrySelector = this.ttf.readUnsignedShort();
        this.rangeShift = this.ttf.readUnsignedShort();
        int i = 0;
        while (i < this.numberOfTables) {
            this.ttf.seek(12 + i * 16);
            byte[] b = new byte[4];
            this.ttf.readFully(b);
            String tag = new String(b);
            int checksum = this.ttf.readInt();
            int offset = this.ttf.readInt();
            int len = this.ttf.readInt();
            TTFFileInput input = new TTFFileInput(this.ttf, offset, len, checksum);
            this.newTable(tag, input);
            ++i;
        }
    }

    public int getFontVersion() {
        return this.sfntMajorVersion;
    }

    public void close() throws IOException {
        super.close();
        this.ttf.close();
    }

    public void show() {
        super.show();
        System.out.println("Font: " + this.fileName);
        System.out.println("  sfnt: " + this.sfntMajorVersion + "." + this.sfntMinorVersion);
        System.out.println("  numTables: " + this.numberOfTables);
        System.out.println("  searchRange: " + this.searchRange);
        System.out.println("  entrySelector: " + this.entrySelector);
        System.out.println("  rangeShift: " + this.rangeShift);
    }
}

