/*
 * Copyright 1997-2002 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.handlers;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;

/**
 * image/gif  DataContentHandler łB
 */
public class image_gif implements DataContentHandler {

	private static ActivationDataFlavor myDF =
		new ActivationDataFlavor(Image.class, "image/gif", "GIF Image");

	protected ActivationDataFlavor getDF() {
		return myDF;
	}

	/**
	 *  <code>DataContentHandler</code>  DataFlavor zԂ܂B
	 * 
	 * @return DataFlavor z
	 */
	public DataFlavor[] getTransferDataFlavors() { // throws Exception;
		return new DataFlavor[] { getDF() };
	}

	/**
	 * Return the Transfer Data of type DataFlavor from InputStream.
	 *
	 * @param df DataFlavor
	 * @param ds f[^ɑΉ̓Xg[
	 * @return String IuWFNg
	 */
	public Object getTransferData(final DataFlavor df, final DataSource ds) throws IOException {
		// use myDF.equals to be sure to get ActivationDataFlavor.equals,
		// which properly ignores Content-Type parameters in comparison
		if (getDF().equals(df))
			return getContent(ds);
		return null;
	}

	public Object getContent(final DataSource ds) throws IOException {
		InputStream is = ds.getInputStream();
		int pos = 0;
		int count;
		byte buf[] = new byte[1024];

		while ((count = is.read(buf, pos, buf.length - pos)) != -1) {
			pos += count;
			if (pos >= buf.length) {
				int size = buf.length;
				if (size < 256 * 1024)
					size += size;
				else
					size += 256 * 1024;
				byte tbuf[] = new byte[size];
				System.arraycopy(buf, 0, tbuf, 0, pos);
				buf = tbuf;
			}
		}
		Toolkit tk = Toolkit.getDefaultToolkit();
		return tk.createImage(buf, 0, pos);
	}

	/**
	 * w肳ꂽ MIME ^CvgpāAo̓Xg[ɃIuWFNgo͂܂B
	 */
	public void writeTo(final Object obj, final String type, final OutputStream os) throws IOException {
		if (!(obj instanceof Image))
			throw new IOException('\"' + getDF().getMimeType() + "\" DataContentHandler requires Image object, was given object of type " + obj.getClass().toString());

		throw new IOException(getDF().getMimeType() + " encoding not supported");
	}

}
