/*
 * Copyright 1997-2003 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.handlers;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.mail.Message;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;

public final class message_rfc822 implements DataContentHandler {

	ActivationDataFlavor ourDataFlavor =
    	new ActivationDataFlavor(Message.class, "message/rfc822", "Message");

	/**
	 * <code>DataContentHandler</code>  DataFlavor zԂ܂B
	 * 
	 * @return DataFlavor z
	 */
	public DataFlavor[] getTransferDataFlavors() {
		return new DataFlavor[] { ourDataFlavor };
	}

	/**
	 * return the Transfer Data of type DataFlavor from InputStream
	 * 
	 * @param df DataFlavor
	 * @param ds f[^ɑΉ̓Xg[
	 * @return Message IuWFNg
	 */
	public Object getTransferData(final DataFlavor df, final DataSource ds) throws IOException {
		// make sure we can handle this DataFlavor
		if (ourDataFlavor.equals(df))
			return getContent(ds);
	    return null;
	}
    
	/**
	 * eԂ܂B
	 */
	public Object getContent(final DataSource ds) throws IOException {
		// VK MimeMessage 쐬܂
		try {
			Session session;
			if (ds instanceof MessageAware) {
				MessageContext mc = ((MessageAware)ds).getMessageContext();
				session = mc.getSession();
			} else {
				// Hopefully a rare case.  Also hopefully the application
				// has created a default Session that can just be returned
				// here.  If not, the one we create here is better than
				// nothing, but overall not a really good answer.
				session = Session.getDefaultInstance(new Properties(), null);
			}
			return new MimeMessage(session, ds.getInputStream());
		} catch (MessagingException me) {
			throw new IOException("Exception creating MimeMessage in message/rfc822 DataContentHandler: " + me.toString());
		}
	}

	/**
	 * oCgXg[IuWFNg\z܂B
	 * (similar semantically to previous method, we are deciding which one to support)
	 */
	public void writeTo(final Object obj, final String mimeType, final OutputStream os) throws IOException {
		// if the object is a message, we know how to write that out
		if (obj instanceof Message) {
			Message m = (Message) obj;
			try {
				m.writeTo(os);
			} catch (MessagingException me) {
				throw new IOException(me.toString());
			}
		} else
			throw new IOException("unsupported object");
	}

}
