/*
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.handlers;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.OutputStream;

import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;

public final class multipart_mixed implements DataContentHandler {

	private ActivationDataFlavor myDF =
		new ActivationDataFlavor(MimeMultipart.class, "multipart/mixed", "Multipart");

	/**
	 *  <code>DataContentHandler</code>  DataFlavor zԂ܂B
	 * 
	 * @return DataFlavor z
	 */
	public DataFlavor[] getTransferDataFlavors() { // throws Exception;
		return new DataFlavor[] { myDF };
	}

	/**
	 * Return the Transfer Data of type DataFlavor from InputStream.
	 * 
	 * @param df DataFlavor
	 * @param ds f[^ɑΉ̓Xg[
	 * @return String IuWFNg
	 */
	public Object getTransferData(final DataFlavor df, final DataSource ds) {
		// use myDF.equals to be sure to get ActivationDataFlavor.equals,
		// which properly ignores Content-Type parameters in comparison
		if (myDF.equals(df))
			return getContent(ds);
		return null;
	}

	/**
	 * eԂ܂B
	 */
	public Object getContent(final DataSource ds) {
		try {
			return new MimeMultipart(ds); 
		} catch (MessagingException e) {
			return null;
		}
	}

	/**
	 * w肳ꂽ MIME ^CvgpāAo̓Xg[ɃIuWFNgo͂܂B
	 */
	public void writeTo(final Object obj, final String mimeType, final OutputStream os) throws IOException {
		if (obj instanceof MimeMultipart) {
			try {
				((MimeMultipart)obj).writeTo(os);
			} catch (MessagingException e) {
				throw new IOException(e.toString());
			}
		}
	}

}
