/*
 * Copyright 1997-2003 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.handlers;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;

import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeUtility;

import jp.sourceforge.livez.mail.util.JISAutoDetect;
import jp.sourceforge.livez.mail.util.UTF7;
import jp.sourceforge.livez.mail.util.WindowsEUCJP;
import jp.sourceforge.livez.mail.util.WindowsJIS;

/**
 * text/plain  DataContentHandler łB
 */
public class text_plain implements DataContentHandler {

	private static ActivationDataFlavor myDF =
		new ActivationDataFlavor(String.class, "text/plain", "Text String");

	protected ActivationDataFlavor getDF() {
		return myDF;
	}

	/**
	 *  <code>DataContentHandler</code>  DataFlavor zԂ܂B
	 * 
	 * @return DataFlavor z
	 */
	public DataFlavor[] getTransferDataFlavors() {
		return new DataFlavor[] { getDF() };
	}

	/**
	 * Return the Transfer Data of type DataFlavor from InputStream.
	 * 
	 * @param df DataFlavor
	 * @param ds f[^ɑΉ̓Xg[
	 * @return String IuWFNg
	 */
	public Object getTransferData(final DataFlavor df, final DataSource ds) throws IOException {
		// use myDF.equals to be sure to get ActivationDataFlavor.equals,
		// which properly ignores Content-Type parameters in comparison
		if (getDF().equals(df))
			return getContent(ds);
		return null;
	}

	public Object getContent(final DataSource ds) throws IOException {
		String enc = null;
		InputStreamReader is = null;

		try {
			enc = getCharset(ds.getContentType());
// Sugisawa changed. 2004/03/09
//			is = new InputStreamReader(ds.getInputStream(), enc);

// Sugisawa added. 2004/03/09
if ("ISO-2022-JP".equalsIgnoreCase(enc))
	is = new InputStreamReader(ds.getInputStream(), "ISO-8859-1");
else if ("Shift_JIS".equalsIgnoreCase(enc))
	is = new InputStreamReader(ds.getInputStream(), "Windows-31J");
else if ("euc-jp".equalsIgnoreCase(enc))
	is = new InputStreamReader(ds.getInputStream(), "ISO-8859-1");
else if ("utf7".equalsIgnoreCase(enc))
	is = new InputStreamReader(ds.getInputStream(), "ISO-8859-1");
else
	is = new InputStreamReader(ds.getInputStream(), enc);

		} catch (IllegalArgumentException iex) {
			/*
			 * An unknown charset of the form ISO-XXX-XXX will cause
			 * the JDK to throw an IllegalArgumentException.  The
			 * JDK will attempt to create a classname using this string,
			 * but valid classnames must not contain the character '-',
			 * and this results in an IllegalArgumentException, rather than
			 * the expected UnsupportedEncodingException.  Yikes.
			 */
			throw new UnsupportedEncodingException(enc);
		}

		int pos = 0;
		int count;
		char buf[] = new char[1024];

		while ((count = is.read(buf, pos, buf.length - pos)) != -1) {
			pos += count;
			if (pos >= buf.length) {
				int size = buf.length;
				if (size < 256*1024)
					size += size;
				else
					size += 256*1024;
				char tbuf[] = new char[size];
				System.arraycopy(buf, 0, tbuf, 0, pos);
				buf = tbuf;
			}
		}

// Sugisawa changed. 2004/03/09
//		return new String(buf, 0, pos);

// Sugisawa added. 2004/03/09
if ("ISO-2022-JP".equalsIgnoreCase(enc)) {
	// Content-Type ł JIS ƌȂʂ̃GR[h{Ɏw肵Ăꍇ̂ŊȈՓIɌ
	return JISAutoDetect.decode(new String(buf, 0, pos));

} else if ("euc-jp".equalsIgnoreCase(enc)) {
	String s = new String(buf, 0, pos);
	try {
		return WindowsEUCJP.decode(s.getBytes("ISO-8859-1"));
	} catch (Exception e) {
		return s;
	}
} else if ("utf7".equalsIgnoreCase(enc)) {
	String s = new String(buf, 0, pos);
	try {
		byte[] bytes = s.getBytes("ISO-8859-1");
		return UTF7.decode(bytes);
	} catch (Exception e) {
		return s;
	}
} else
	return new String(buf, 0, pos);

	}

	/**
	 * w肳ꂽ MIME ^CvgpāAo̓Xg[ɃIuWFNgo͂܂B
	 */
    public void writeTo(final Object obj, final String type, final OutputStream os) throws IOException {
		if (!(obj instanceof String))
			throw new IOException('\"' + getDF().getMimeType() + "\" DataContentHandler requires String object, was given object of type " + obj.getClass().toString());

		String enc = null;
		OutputStreamWriter osw = null;

		try {
			enc = getCharset(type);
// Sugisawa changed. 2004/03/09
//		    osw = new OutputStreamWriter(os, enc);

// Sugisawa added. 2004/03/09
if ("ISO-2022-JP".equalsIgnoreCase(enc))
	osw = new OutputStreamWriter(os, "ISO-8859-1");
else if ("Shift_JIS".equalsIgnoreCase(enc))
	osw = new OutputStreamWriter(os, "Windows-31J");
else if ("euc-jp".equalsIgnoreCase(enc))
	osw = new OutputStreamWriter(os, "ISO-8859-1");
else
	osw = new OutputStreamWriter(os, enc);

		} catch (IllegalArgumentException iex) {
			/*
			 * An unknown charset of the form ISO-XXX-XXX will cause
			 * the JDK to throw an IllegalArgumentException.  The
			 * JDK will attempt to create a classname using this string,
			 * but valid classnames must not contain the character '-',
			 * and this results in an IllegalArgumentException, rather than
			 * the expected UnsupportedEncodingException.  Yikes.
			 */
			throw new UnsupportedEncodingException(enc);
		}

		String s = (String) obj;
// Sugisawa added. 2004/03/09
if ("ISO-2022-JP".equalsIgnoreCase(enc))
	s = new String(WindowsJIS.encode(s), "ISO-8859-1");
else if ("euc-jp".equalsIgnoreCase(enc))
	s = new String(WindowsEUCJP.encode(s), "ISO-8859-1");

		osw.write(s, 0, s.length());
		osw.flush();
    }

    // Sugisawa added. 2005/04/03
	private String getCharset(final String type) {
		String charset = null;
		try {
			ContentType ct = new ContentType(type);
			charset = ct.getParameter("charset");
		} catch (Exception ex) {}	// 

		if (charset == null || "us-ascii".equalsIgnoreCase(charset))
			charset = System.getProperty("mail.mime.charset");
		if (charset == null || "us-ascii".equalsIgnoreCase(charset)) {
			if ("ja".equalsIgnoreCase(Locale.getDefault().getLanguage()))
				charset = "ISO-2022-JP";
			else
				charset = "us-ascii";
		}
		return MimeUtility.javaCharset(charset);
	}

/* Sugisawa changed. 2005/04/03
	private String getCharset(final String type) {
		try {
			ContentType ct = new ContentType(type);
			String charset = ct.getParameter("charset");
			if (charset == null)
				// If the charset parameter is absent, use US-ASCII.
				charset = "us-ascii";
			return MimeUtility.javaCharset(charset);
		} catch (Exception ex) {

			return null;
		}
	}
*/

}
