/*
 * Copyright 1997-2002 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.iap;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

import com.sun.mail.util.ASCIIUtility;

import jp.sourceforge.livez.mail.util.WindowsEUCJP;
import jp.sourceforge.livez.mail.util.WindowsJIS;

public final class Argument {

	protected Vector items;

	/**
	 * ftHgRXgN^łB
	 */
	public Argument() {
		items = new Vector(1);
	}

	/**
	 * w肳ꂽ Argument  Argument ɒǉ܂B
	 * SĂ̍ڂRs[܂B
	 */
	public void append(final Argument arg) {
		items.ensureCapacity(items.size() + arg.items.size());
		for (int i=0; i < arg.items.size(); i++)
			items.addElement(arg.items.elementAt(i));
	}

	/**
	 * Write out given string as an ASTRING, depending on the type
	 * of the characters inside the string. The string should
	 * contain only ASCII characters. <p>
	 * 
	 * @param s o͂ String
	 * @since Sugisawa changed. 2005/01/07 \bh writeString ύX
	 */
	public void writeASCII(final String s) {
		items.addElement(new AString(ASCIIUtility.getBytes(s)));
	}

	/**
	 * w肳ꂽ charset Ŏw肳ꂽoCgɕϊ܂B
	 * āAASTRING ̃oCgo͂܂B
	 */
	public void writeString(final String s, final String charset) throws UnsupportedEncodingException {
		if (charset == null) // convenience
			writeASCII(s);
		else
			items.addElement(new AString(s.getBytes(charset)));
	}

// Sugisawa added. 2004/6/30
public void writeRawString(final String s, final String charset) throws UnsupportedEncodingException {
	if (charset == null) // convenience
		writeASCII(s);
	else {
		if (charset.equalsIgnoreCase("ISO-2022-JP"))
			items.addElement(new RawString(WindowsJIS.encode(s)));
		else if (charset.equalsIgnoreCase("Shift_JIS"))
			items.addElement(new RawString(s.getBytes("Windows-31J")));
		else if (charset.equalsIgnoreCase("euc-jp") || charset.equalsIgnoreCase("eucjp-open"))
			items.addElement(new RawString(WindowsEUCJP.encode(s)));
		else
			items.addElement(new RawString(s.getBytes(charset)));
	}
}

	/**
	 * Write out given byte[] as a Literal.
	 * 
	 * @param b o͂ byte[]
	 */
	public void writeBytes(final byte[] b) {
		items.addElement(b);
	}

	/**
	 * Write out given ByteArrayOutputStream as a Literal.
	 * 
	 * @param b o͂ ByteArrayOutputStream
	 */
	public void writeBytes(final ByteArrayOutputStream b) {
		items.addElement(b);
	}

	/**
	 * Write out given data as a literal.
	 * 
	 * @param b o͂f[^\ Literal
	 */
	public void writeBytes(final Literal b)  {
		items.addElement(b);
	}

	/**
	 * Write out given string as an Atom. Note that an Atom can contain only
	 * certain US-ASCII characters.  No validation is done on the characters 
	 * in the string.
	 * 
	 * @param s String
	 */
	public void writeAtom(final String s) {
		items.addElement(new Atom(s));
	}

	/**
	 * lo͂܂B
	 * 
	 * @param i l
	 */
	public void writeNumber(final int i) {
		items.addElement(new Integer(i));
	}

	/**
	 * lo͂܂B
	 * 
	 * @param i l
	 */
	public void writeNumber(final long i) {
		items.addElement(new Long(i));
	}

	/**
	 * ʕtXgƂďo͂܂B
	 * 
	 * @param c Xe[gg
	 */
	public void writeArgument(final Argument c) {
		items.addElement(c);
	}

	/*
	 * SẴobt@Oꂽڂo̓Xg[ɏo͂܂B
	 */
	public void write(final Protocol protocol) throws IOException, ProtocolException {
		int size = items != null ? items.size() : 0;
		DataOutputStream os = (DataOutputStream) protocol.getOutputStream();

		for (int i = 0; i < size; i++) {
			if (i > 0)	// ŏ̍ڂ̏ꍇ͋؂蕶o͂܂
				os.write(' ');
	
			Object o = items.elementAt(i);
			if (o instanceof Atom) {
				os.writeBytes(((Atom)o).string);
			} else if (o instanceof Number) {
				os.writeBytes(((Number)o).toString());
			} else if (o instanceof AString) {
				astring(((AString)o).bytes, protocol);
// Sugisawa added. 2004/6/30
} else if (o instanceof RawString) {
	os.write(((RawString)o).bytes);
			} else if (o instanceof byte[]) {
				literal((byte[])o, protocol);
			} else if (o instanceof ByteArrayOutputStream) {
				literal((ByteArrayOutputStream)o, protocol);
			} else if (o instanceof Literal) {
				literal((Literal)o, protocol);
			} else if (o instanceof Argument) {
				os.write('('); // open parans
				((Argument)o).write(protocol);
				os.write(')'); // close parans
			}
		}
	}

	/**
	 * Write out given String as either an Atom, QuotedString or Literal
	 */
	private void astring(final byte[] bytes, final Protocol protocol) throws IOException, ProtocolException {
		DataOutputStream os = (DataOutputStream) protocol.getOutputStream();
		int len = bytes.length;

		//  1024 oCg𒴂ꍇAeƂđM܂B
		if (len > 1024) {
			literal(bytes, protocol);
			return;
		}

		//  0 ̏ꍇANI[ebhXgOƂđM܂B
		boolean quote = len == 0 ? true: false;
		boolean escape = false;

		byte b;
		for (int i = 0; i < len; i++) {
			b = bytes[i];
			if (b == '\0' || b == '\r' || b == '\n' || ((b & 0xff) > 0177)) {
				// NULACR  LF ́AoCg literals ƂđKv鎖Ӗ܂
				literal(bytes, protocol);
				return;
			}
			if (b == '*' || b == '%' || b == '(' || b == ')' || b == '{' ||
				b == '"' || b == '\\' || ((b & 0xff) <= ' ')) {
				quote = true;
				if (b == '"' || b == '\\') // need to escape these characters
					escape = true;
			}
		}

		if (quote) // start quote
			os.write('"');

		if (escape) {
			// already quoted
			for (int i = 0; i < len; i++) {
				b = bytes[i];
				if (b == '"' || b == '\\')
					os.write('\\');
				os.write(b);
			}
		} else 
			os.write(bytes);

		if (quote) // end quote
			os.write('"');
	}

	/**
	 * Write out given byte[] as a literal
	 */
	private void literal(final byte[] b, final Protocol protocol) throws IOException, ProtocolException {
		startLiteral(protocol, b.length).write(b);
	}

	/**
	 * Write out given ByteArrayOutputStream as a literal.
	 */
	private void literal(final ByteArrayOutputStream b, final Protocol protocol) throws IOException, ProtocolException {
		b.writeTo(startLiteral(protocol, b.size()));
	}

	/**
	 * Write out given Literal as a literal.
	 */
	private void literal(final Literal b, final Protocol protocol) throws IOException, ProtocolException {
		b.writeTo(startLiteral(protocol, b.size()));
	}

	private OutputStream startLiteral(final Protocol protocol, final int size) throws IOException, ProtocolException {
		DataOutputStream os = (DataOutputStream) protocol.getOutputStream();
		boolean nonSync = protocol.supportsNonSyncLiterals();

		os.write('{');
		os.writeBytes(Integer.toString(size));
		if (nonSync) // T[o񓯊eT|[gꍇ
			os.writeBytes("+}\r\n");
		else
			os.writeBytes("}\r\n");
		os.flush();

		// egpĂꍇAT[ǒpVOi҂܂
		if (!nonSync) {
			for (; ;) {
				Response r = protocol.readResponse();
				if (r.isContinuation())
					break;
				if (r.isTagged())
					throw new LiteralException(r);
				// XXX - ^OtĂȂX|X𖳎܂B
				//	IMAP dl(T[oȂƂ])Ɉᔽ܂
			}
		}
		return os;
	}

}

final class Atom {

	String string;

	Atom(final String s) {
		string = s;
	}

}

final class AString {

	byte[] bytes;

	AString(final byte[] b) {
		bytes = b;
	}

}

// Sugisawa added. 2004/6/30
final class RawString {

	byte[] bytes;

	RawString(final byte[] b) {
		bytes = b;
	}

}
