/*
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.iap;

import java.io.ByteArrayInputStream;

/**
 * A simple wrapper around a byte array, with a start position and
 * count of bytes.
 */
public final class ByteArray {

	private byte[] bytes;	// oCgz
	private int start;		// Jnʒu
	private int count;		// oCg

	/**
	 * RXgN^łB
	 */
	public ByteArray(final byte[] b, final int start, final int count) {
		bytes = b;
		this.start = start;
		this.count = count;
	}

	/**
	 * Returns the internal byte array. Note that this is a live
	 * reference to the actual data, not a copy.
	 */
	public byte[] getBytes() {
		return bytes;
	}

	/**
	 * Returns a new byte array that is a copy of the data.
	 */
	public byte[] getNewBytes() {
		byte[] b = new byte[count];
		System.arraycopy(bytes, start, b, 0, count);
		return b;
	}

	/**
	 * JnʒuԂ܂B
	 */
	public int getStart() {
		return start;
	}

	/**
	 * oCgԂ܂B
	 */
	public int getCount() {
		return count;
	}

	/**
	 * ByteArrayInputStream Ԃ܂B
	 */
	public ByteArrayInputStream toByteArrayInputStream() {
		return new ByteArrayInputStream(bytes, start, count);
	}

}
