/*
 * Copyright 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.iap;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Properties;
import java.util.Vector;

import com.sun.mail.util.SocketFetcher;
import com.sun.mail.util.TraceInputStream;
import com.sun.mail.util.TraceOutputStream;

public class Protocol {

	protected String host;
	private Socket socket;
	// TLS ꍇɔČłKvƂ܂
	protected boolean debug;
	protected boolean quote;
	protected PrintStream out;

	private TraceInputStream traceInput;	// g[T[
	private ResponseInputStream input;

	private TraceOutputStream traceOutput;	// g[T[
	private DataOutputStream output;

	private int tagCounter = 0;

	private Vector handlers = null;		// X|XnhQ

	private long timestamp;

	protected static final byte[] CRLF = { (byte)'\r', (byte)'\n'};

	/**
	 * RXgN^łB<p>
	 * 
	 * ^ꂽ|[gŗ^ꂽzXgɐڑJ܂B
	 * 
	 * @param host ڑ̃zXg
	 * @param port ڑ̃|[g
	 * @param debug fobO[h
	 * @param out fobOpo̓Xg[
	 * @param props ̃vgRŎgp Properties IuWFNg
	 * @param prefix vpeBL[̑Oɕtړ
	 * @throws IOException
	 * @throws ProtocolException
	 */
	public Protocol(
		final String host,
		final int port,
		final boolean debug,
		final PrintStream out,
		final Properties props,
		final String prefix,
		final boolean isSSL)
		throws IOException, ProtocolException {

		this.host = host;
		this.debug = debug;
		this.out = out;

		socket = SocketFetcher.getSocket(host, port, props, prefix);
		String s = props.getProperty("mail.debug.quote");
		this.quote = s != null && s.equalsIgnoreCase("true");

		initStreams(out);

		// Read server greeting
		processGreeting(readResponse());

		timestamp = System.currentTimeMillis();
	}

	private void initStreams(final PrintStream out) throws IOException {
		traceInput = new TraceInputStream(socket.getInputStream(), out);
		traceInput.setTrace(debug);
		traceInput.setQuote(quote);
		input = new ResponseInputStream(traceInput);

		traceOutput = new TraceOutputStream(socket.getOutputStream(), out);
		traceOutput.setTrace(debug);
		traceOutput.setQuote(quote);
		output = new DataOutputStream(new BufferedOutputStream(traceOutput));
	}

	/**
	 * fobÖׂ̃RXgN^łB
	 */
	public Protocol(final InputStream in, final OutputStream out, final boolean debug) {
		this.host = "localhost";
		this.debug = debug;
		this.quote = false;
		this.out = System.out;

		// XXX - inlined initStreams, won't allow later startTLS
		traceInput = new TraceInputStream(in, System.out);
		traceInput.setTrace(debug);
		traceInput.setQuote(quote);
		input = new ResponseInputStream(traceInput);

		traceOutput = new TraceOutputStream(out, System.out);
		traceOutput.setTrace(debug);
		traceOutput.setQuote(quote);
		output = new DataOutputStream(new BufferedOutputStream(traceOutput));
		timestamp = System.currentTimeMillis();
	}

	/**
	 * ^CX^vԂ܂B
	 */
	public final long getTimestamp() {
		return timestamp;
	}

	/**
	 * X|Xnhǉ܂B
	 */
	public synchronized final void addResponseHandler(final ResponseHandler h) {
		if (handlers == null)
			handlers = new Vector();
		handlers.addElement(h);
	}

	/**
	 * w肳ꂽX|Xnh폜܂B
	 */
	public synchronized final void removeResponseHandler(final ResponseHandler h) {
		if (handlers != null)
			handlers.removeElement(h);
	}

	/**
	 * X|Xnhɒʒm܂B
	 */
	public final void notifyResponseHandlers(final Response[] responses) {
		if (handlers == null)
			return;

		for (int i = 0; i < responses.length; i++) { // go thru responses
			Response r = responses[i];

			// skip responses that have already been handled
			if (r == null)
				continue;

			int size = handlers.size();
			if (size == 0)
				return;
			// Need to copy handlers list because handlers can be removed
			// when handling a response.
			Object aobj[] = new Object[size];
			handlers.copyInto(aobj);
			// dispatch 'em
			for (int j = 0; j < size; j++)
				((ResponseHandler)aobj[j]).handleResponse(r);
		}
	}

	protected void processGreeting(final Response r) throws ProtocolException {
		if (r.isBYE())
			throw new ConnectionException(this, r);
	}

	/**
	 * Protocol ̓̓Xg[Ԃ܂B
	 */
	protected final ResponseInputStream getInputStream() {
		return input;
	}

	/**
	 * Protocol ̏o̓Xg[Ԃ܂B
	 */
	protected final OutputStream getOutputStream() {
		return output;
	}

	/**
	 * Returns whether this Protocol supports non-synchronizing literals
	 * Default is false. Subclasses should override this if required
	 */
	protected boolean supportsNonSyncLiterals() {
		return false;
	}

	public Response readResponse() throws IOException, ProtocolException {
		return new Response(this);
	}

	public final String writeCommand(
		final String command,
		final Argument args)
		throws IOException, ProtocolException {

		String tag = 'A' + Integer.toString(tagCounter++, 10); // j[N^O

		output.writeBytes(tag + ' ' + command);

		if (args != null) {
			output.write(' ');
			args.write(this);
		}

		output.write(CRLF);
		output.flush();
		return tag;
	}

	/**
	 * R}hT[oɑM܂B
	 * Collect all responses until either
	 * the corresponding command completion response or a BYE response 
	 * (indicating server failure).
	 * WSẴX|XԂ܂B
	 * 
	 * @param command R}h
	 * @param args 
	 * @return T[oԂꂽ Response IuWFNg̔zԂ܂B
	 */
	public synchronized final Response[] command(final String command, final Argument args) {
		Vector v = new Vector();
		boolean done = false;
		String tag = null;
		Response r = null;

		// R}ho͂܂
		try {
			tag = writeCommand(command, args);
		} catch (LiteralException lex) {
			v.addElement(lex.getResponse());
			done = true;
		} catch (Exception ex) {
			// BYE X|Xɕϊ܂
			v.addElement(Response.byeResponse(ex));
			done = true;
		}

		while (!done) {
			try {
				r = readResponse();
			} catch (IOException ioex) {
				// BYE X|Xɕϊ܂
				r = Response.byeResponse(ioex);
			} catch (ProtocolException pex) {
				continue; // ̃X|XXLbv܂
			}

			v.addElement(r);

			if (r.isBYE()) // shouldn't wait for command completion response
				done = true;

			// If this is a matching command completion response, we are done
			if (r.isTagged() && r.getTag().equals(tag))
				done = true;
		}

		Response[] responses = new Response[v.size()];
		v.copyInto(responses);
		timestamp = System.currentTimeMillis();
		return responses;
	}

	/**
	 * OKANOABAD  BYE X|X֐ׂ̈̃[`łB
	 */
	public final void handleResult(final Response response) throws ProtocolException {
		if (response.isOK())
			return;
		else if (response.isNO())
			throw new CommandFailedException(response);
		else if (response.isBAD())
			throw new BadCommandException(response);
		else if (response.isBYE()) {
			disconnect();
			throw new ConnectionException(this, response);
		}
	}

	/**
	 * Convenience routine to handle simple IAP commands
	 * that do not have responses specific to that command.
	 */
	public final void simpleCommand(final String cmd, final Argument args) throws ProtocolException {
		// R}hs
		Response[] r = command(cmd, args);
		// dispatch untagged responses
		notifyResponseHandlers(r);
		// Handle result of this command
		handleResult(r[r.length - 1]);
	}

	/**
	 * Start TLS on the current connection.
	 * <code>cmd</code> is the command to issue to start TLS negotiation.
	 * If the command succeeds, we begin TLS negotiation.
	 */
	public final void startTLS(final String s) throws IOException, ProtocolException {
		simpleCommand(s, null);
		socket = SocketFetcher.startTLS(socket);
		initStreams(out);
	}

	/**
	 * ؒf܂B
	 */
	protected synchronized void disconnect() {
		if (socket != null) {
			try {
				socket.close();
			} catch (IOException e) {}
			socket = null;
		}
	}

	/**
	 * t@CiCUłB
	 */
	protected final void finalize() throws Throwable {
		super.finalize();
		disconnect();
	}

}
