/*
 * Copyright 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.iap;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Vector;

import com.sun.mail.util.ASCIIUtility;

/**
 * ̃NX IMAP T[oɊ֘A̓Xg[̃X|X\܂B
 */
public class Response {

	protected int index;	// CfbNX (updated during the parse)
	protected int pindex;	// index after parse, for reset
	protected int size;	// number of valid bytes in our buffer
	protected byte[] buffer = null;
	protected int type = 0;
	protected String tag = null;

// Sugisawa changed. 2004/12/28
//    private static final int increment = 100;

	// The first and second bits indicate whether this response
	// is a Continuation, Tagged or Untagged
	public static final int TAG_MASK		= 0x03;
	public static final int CONTINUATION	= 0x01;
	public static final int TAGGED		= 0x02;
	public static final int UNTAGGED		= 0x03;

	// The third, fourth and fifth bits indicate whether this response
	// is an OK, NO, BAD or BYE response
	public static final int TYPE_MASK	= 0x1C;
	public static final int OK			= 0x04;
	public static final int NO			= 0x08;
	public static final int BAD			= 0x0C;
	public static final int BYE			= 0x10;
	public static final int SYNTHETIC		= 0x20;

	/**
	 * RXgN^łB
	 * 
	 * @param s
	 */
	public Response(final String s) {
		buffer = ASCIIUtility.getBytes(s);
		size = buffer.length;
		parse();
	}

	/**
	 * w肳ꂽvgRV Response ǂ݂܂B
	 * 
	 * @param p Protocol IuWFNg
	 */
	public Response(final Protocol p) throws IOException /*, ProtocolException */ {
		// 'obt@' ̃X|Xǂ݂܂
		ByteArray response = p.getInputStream().readResponse();
		buffer = response.getBytes();
		size = response.getCount() - 2; // Ō CRLF XLbv܂
		parse();
	}

	/**
	 * Rs[p̃RXgN^łB
	 */
	public Response(final Response r) {
		index = r.index;
		size = r.size;
		buffer = r.buffer;
		type = r.type;
		tag = r.tag;
	}

	/**
	 * Return a Response object that looks like a BYE protocol response.
	 * Include the details of the exception in the response string.
	 */
	public static Response byeResponse(final Exception e) {
		String s = "* BYE JavaMail Exception: " + e.toString();
		s = s.replace('\r', ' ').replace('\n', ' ');
		Response r = new Response(s);
		r.type |= SYNTHETIC;
		return r;
	}

	private void parse() {
		index = 0; // position internal index at start

		if (buffer[index] == '+') { // Continuation statement
			type |= CONTINUATION;
			index += 1; // Position beyond the '+'
			return;	// return
		} else if (buffer[index] == '*') { // Untagged statement
			type |= UNTAGGED;
			index += 1; // Position beyond the '*'
		} else {  // Tagged statement
			type |= TAGGED;
			tag = readAtom();	// read the TAG, index positioned beyond tag
		}

		int mark = index; // }[N
		String s = readAtom(); // CfbNXXV
		if (s.equalsIgnoreCase("OK"))
			type |= OK;
		else if (s.equalsIgnoreCase("NO"))
			type |= NO;
		else if (s.equalsIgnoreCase("BAD"))
			type |= BAD;
		else if (s.equalsIgnoreCase("BYE"))
			type |= BYE;
		else
			index = mark; // Zbg

		pindex = index;
	}

	public final void skipSpaces() {
		while (index < size && buffer[index] == ' ')
			index++;
	}

	/**
	 * ̃Xy[X܂ŃXLbv܂Bfor use in error recovery while parsing.
	 */
	public final void skipToken() {
		while (index < size && buffer[index] != ' ')
			index++;
	}

	public final void skip(final int count) {
		index += count;
	}

	public final byte peekByte() {
		if (index < size)
			return buffer[index];
		return 0;		// XXX - how else to signal error?
	}

	/**
	 * Return the next byte from this Statement.
	 * 
	 * @return the next byte.
	 */
	public final byte readByte() {
		if (index < size)
			return buffer[index++];
		return 0;		// XXX - how else to signal error?
	}

	/**
	 * Extract an ATOM, starting at the current position. Updates
	 * the internal index to beyond the Atom.
	 * 
	 * @return Atom
	 */
	public final String readAtom() {
		return readAtom('\0');
	}

	/**
	 * Extract an ATOM, but stop at the additional delimiter
	 * (if not NUL).  Used to parse a response code inside [].
	 */
	public final String readAtom(final char delim) {
		skipSpaces();

		if (index >= size) // ɃX|X̏IɒBĂꍇ
			return null;

		/* ATOM is any CHAR delimited by :
		 * SPACE | CTL | '(' | ')' | '{' | '%' | '*' | '"' | '\'
		 */
		byte b;
		int start = index;
		while (index < size && ((b = buffer[index]) > ' ') &&
			b != '(' && b != ')' && b != '%' && b != '*' && 
			b != '"' && b != '\\' && b != 0x7f &&
			(delim == '\0' || b != delim))
				index++;

		return ASCIIUtility.toString(buffer, start, index);
	}

	public String readString(final char c) {
		skipSpaces();
		if (index >= size)
			return null;
		int i = index;
		for(; index < size && buffer[index] != c; index++);
		return ASCIIUtility.toString(buffer, i, index);
	}

	public final String[] readStringList() {
		skipSpaces();

		if (buffer[index] != '(') // not what we expected
		    return null;
		index++; // '(' XLbv

		Vector v = new Vector();
		do {
		    v.addElement(readString());
		} while (buffer[index++] != ')');

		int size = v.size();
		if (size > 0) {
		    String[] s = new String[size];
		    v.copyInto(s);
		    return s;
		}
		// ̃Xg
	    return null;
	}

	/**
	 * Extract an integer, starting at the current position. Updates the
	 * internal index to beyond the number. Returns -1 if  a number was 
	 * not found.
	 * 
	 * @return l
	 */
	public final int readNumber() {
		// Skip leading spaces
		skipSpaces();

	    int start = index;
	    while (index < size && Character.isDigit((char)buffer[index]))
	        index++;

	    if (index > start) {
		    try {
				return ASCIIUtility.parseInt(buffer, start, index);
		    } catch (NumberFormatException nex) {}
		}

		return -1;
	}

	/**
	 * Extract a long number, starting at the current position. Updates the
	 * internal index to beyond the number. Returns -1 if a long number
	 * was not found.
	 *
	 * @return a long
	 */
	public final long readLong() {
		// Skip leading spaces
		skipSpaces();

	    int start = index;
	    while (index < size && Character.isDigit((char)buffer[index]))
	        index++;

	    if (index > start) {
		    try {
				return ASCIIUtility.parseLong(buffer, start, index);
		    } catch (NumberFormatException nex) {}
		}

		return -1;
	}

	/**
	 * Extract a NSTRING, starting at the current position. Return it as
	 * a String. The sequence 'NIL' is returned as null
	 * 
	 * NSTRING := QuotedString | Literal | "NIL"
	 * 
	 * @return String
	 */
	public final String readString() {
		return (String) parseString(false, true);
	}

	/**
	 * Extract a NSTRING, starting at the current position. Return it as
	 * a ByteArrayInputStream. The sequence 'NIL' is returned as null
	 * 
	 * NSTRING := QuotedString | Literal | "NIL"
	 * 
	 * @return ByteArrayInputStream
	 */
	public final ByteArrayInputStream readBytes() {
		ByteArray ba = readByteArray();
		if (ba != null)
		    return ba.toByteArrayInputStream();
	    return null;
	}

	/**
	 * Extract a NSTRING, starting at the current position. Return it as
	 * a ByteArray. The sequence 'NIL' is returned as null
	 * 
	 * NSTRING := QuotedString | Literal | "NIL"
	 * 
	 * @return ByteArray
	 */
	public final ByteArray readByteArray() {
		/*
		 * Special case, return the data after the continuation uninterpreted.
		 * It's usually a challenge for an AUTHENTICATE command.
		 */
		if (isContinuation()) {
			skipSpaces();
			return new ByteArray(buffer, index, size - index);
		}
		return (ByteArray) parseString(false, false);
	}

	/**
	 * Extract an ASTRING, starting at the current position
	 * and return as a String. An ASTRING can be a QuotedString, a
	 * Literal or an Atom
	 * 
	 * Any errors in parsing returns null
	 * 
	 * ASTRING := QuotedString | Literal | Atom
	 * 
	 * @return String
	 */ 
	public final String readAtomString() {
		return (String) parseString(true, true);
	}

	/**
	 * Generic parsing routine that can parse out a Quoted-String,
	 * Literal or Atom and return the parsed token as a String
	 * or a ByteArray. Errors or NIL data will return null.
	 */
	private Object parseString(final boolean parseAtoms, final boolean returnString) {
		byte b;

		// Skip leading spaces
		skipSpaces();

		b = buffer[index];
		if (b == '"') { // QuotedString
			index++; // skip the quote
			int start = index;
			int copyto = index;

			while ((b = buffer[index]) != '"') {
				if (b == '\\') // skip escaped byte
					index++;
				if (index != copyto) { // only copy if we need to
					// Beware: this is a destructive copy. I'm 
					// pretty sure this is OK, but ... ;>
					buffer[copyto] = buffer[index];
				}
				copyto++;
				index++;
			}
			index++; // skip past the terminating quote

			if (returnString) 
				return ASCIIUtility.toString(buffer, start, copyto);
			return new ByteArray(buffer, start, copyto - start);
		} 
		if (b == '{') { // Literal
			int start = ++index; // note the start position

			while (buffer[index] != '}')
				index++;

			int count = 0;
			try {
				count = ASCIIUtility.parseInt(buffer, start, index);
			} catch (NumberFormatException nex) { 
				// throw new ParsingException();
				return null;
			}

			start = index + 3; // skip "}\r\n"
			index = start + count; // position index to beyond the literal

			if (returnString) // return as String
				return ASCIIUtility.toString(buffer, start, start + count);
			return new ByteArray(buffer, start, count);
		}
		if (parseAtoms) { // parse as an ATOM
			int start = index;	// track this, so that we can use to
				// creating ByteArrayInputStream below.
			String s = readAtom();
			if (returnString)
				return s;
			// *very* unlikely
			return new ByteArray(buffer, start, index);
		}
		if (b == 'N' || b == 'n') { // the only valid value is 'NIL'
			index += 3; // skip past NIL
			return null;
		}

		return null; // G[
	}

	public final int getType() {
		return type;
	}

	public final boolean isContinuation() {
		return ((type & TAG_MASK) == CONTINUATION);
	}

	public final boolean isTagged() {
		return ((type & TAG_MASK) == TAGGED);
	}

	public final boolean isUnTagged() {
		return ((type & TAG_MASK) == UNTAGGED);
	}

	public final boolean isOK() {
		return ((type & TYPE_MASK) == OK);
	}

	public final boolean isNO() {
		return ((type & TYPE_MASK) == NO);
	}

	public final boolean isBAD() {
		return ((type & TYPE_MASK) == BAD);
	}

	public final boolean isBYE() {
		return ((type & TYPE_MASK) == BYE);
	}

	public boolean isSynthetic() {
		return (type & SYNTHETIC) == SYNTHETIC;
	}

	/**
	 * Return the tag, if this is a tagged statement.
	 * 
	 * @return tag of this tagged statement
	 */
	public final String getTag() {
		return tag;
	}

	/**
	 * Return the rest of the response as a string, usually used to
	 * return the arbitrary message text after a NO response.
	 */
	public final String getRest() {
		skipSpaces();
		return ASCIIUtility.toString(buffer, index, size);
	}

	/**
	 * Reset pointer to beginning of response.
	 */
	public final void reset() {
		index = pindex;
	}

	public final String toString() {
		return ASCIIUtility.toString(buffer, 0, size);
	}

}
