/*
 * Copyright 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.imap;

import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;

import com.sun.mail.iap.ProtocolException;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.ListInfo;


public final class DefaultFolder extends IMAPFolder {

	/**
	 * RXgN^łB
	 * 
	 * @param store
	 */
	protected DefaultFolder(final IMAPStore store) {
		super("", UNKNOWN_SEPARATOR , store);
		exists = true;			// of course
		type = HOLDS_FOLDERS;	// obviously
	}

	public String getName() {
		return fullName;
	}

	public Folder getParent() {
		return null;
	}

	public Folder[] list(final String pattern) throws MessagingException {
		ListInfo[] li = null;

		li = (ListInfo[]) doCommand(new ProtocolCommand() {
			public Object doCommand(IMAPProtocol p) throws ProtocolException {
				return p.list("", pattern);
			}
		});

		if (li == null)
			return new Folder[0];

		IMAPFolder[] folders = new IMAPFolder[li.length];
		for (int i = 0; i < folders.length; i++)
			folders[i] = new IMAPFolder(li[i], (IMAPStore)store);

		return folders;
	}

	public Folder[] listSubscribed(final String pattern) throws MessagingException {
		ListInfo[] li = null;

		li = (ListInfo[]) doCommand(new ProtocolCommand() {
			public Object doCommand(IMAPProtocol p) throws ProtocolException {
				return p.lsub("", pattern);
			}
		});

		if (li == null)
			return new Folder[0];

		IMAPFolder[] folders = new IMAPFolder[li.length];
		for (int i = 0; i < folders.length; i++)
			folders[i] = new IMAPFolder(li[i], (IMAPStore)store);

		return folders;
	}

	public boolean hasNewMessages() throws MessagingException {
		// DefaultFolder ł͓K؂łȂ
		return false;
	}

	public Folder getFolder(final String name) throws MessagingException {
		return new IMAPFolder(name, UNKNOWN_SEPARATOR, (IMAPStore)store);
	}

	public boolean delete(final boolean recurse) throws MessagingException {
		// DefaultFolder ł͓K؂łȂ
		throw new MethodNotSupportedException("Cannot delete Default Folder");
	}

	public boolean renameTo(final Folder f) throws MessagingException {
		// DefaultFolder ł͓K؂łȂ
		throw new MethodNotSupportedException("Cannot rename Default Folder");
	}

	public void appendMessages(final Message[] msgs) throws MessagingException {
		// DefaultFolder ł͓K؂łȂ
		throw new MethodNotSupportedException("Cannot append to Default Folder");
	}

	public Message[] expunge() throws MessagingException {
		// DefaultFolder ł͓K؂łȂ
		throw new MethodNotSupportedException("Cannot expunge Default Folder");
	}

}
