/*
 * Copyright 1997-2002 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.imap;

import java.util.Vector;

import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.MultipartDataSource;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;

import com.sun.mail.imap.protocol.BODYSTRUCTURE;


public final class IMAPMultipartDataSource extends MimePartDataSource implements MultipartDataSource {

	private Vector parts;

	protected IMAPMultipartDataSource(
		final MimePart part,
		final BODYSTRUCTURE[] bs,
		final String sectionId,
		final IMAPMessage msg) {

		super(part);

		parts = new Vector(bs.length);
		for (int i = 0; i < bs.length; i++)
			parts.addElement(new IMAPBodyPart(bs[i], sectionId == null ? Integer.toString(i + 1) : sectionId + '.' + Integer.toString(i + 1), msg));
	}

	public int getCount() {
		return parts.size();
	}

	public BodyPart getBodyPart(final int index) throws MessagingException {
		return (BodyPart) parts.elementAt(index);
	}

}
