/*
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.imap;

import javax.mail.Flags;
import javax.mail.FolderClosedException;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;

import com.sun.mail.imap.protocol.BODYSTRUCTURE;
import com.sun.mail.imap.protocol.ENVELOPE;
import com.sun.mail.imap.protocol.IMAPProtocol;


/**
 * ̃NX͓qɂꂽIMAPbZ[W܂B
 */
public final class IMAPNestedMessage extends IMAPMessage {

	private IMAPMessage msg; // the enclosure of this nested message

	/**
	 * pbP[WvCx[gRXgN^łB<p>
	 * 
	 * Note that nested messages have no containing folder, nor 
	 * a message number.
	 */
	IMAPNestedMessage(final IMAPMessage m, final BODYSTRUCTURE b, final ENVELOPE e, final String sid) {
		super(m._getSession());
		msg = m;
		bs = b;
		envelope = e;
		sectionId = sid;
	}

	/*
	 * Get the enclosing message's Protocol object. Overrides
	 * IMAPMessage.getProtocol().
	 */
	protected IMAPProtocol getProtocol() throws FolderClosedException {
		return msg.getProtocol();
	}

	/*
	 * Get the enclosing message's messageCacheLock. Overrides
	 * IMAPMessage.getMessageCacheLock().
	 */
	protected Object getMessageCacheLock() {
		return msg.getMessageCacheLock();
	}

	/*
	 * Get the enclosing message's sequence number. Overrides
	 * IMAPMessage.getSequenceNumber().
	 */
	protected int getSequenceNumber() {
		return msg.getSequenceNumber();
	}

	/*
	 * Check whether the enclosing message is expunged. Overrides 
	 * IMAPMessage.checkExpunged().
	 */
	protected void checkExpunged() throws MessageRemovedException {
		msg.checkExpunged();
	}

	/*
	 * Check whether the enclosing message is expunged. Overrides
	 * Message.isExpunged().
	 */
	public boolean isExpunged() {
		return msg.isExpunged();
	}

	/*
	 * Get the enclosing message's fetchBlockSize. 
	 */
	protected int getFetchBlockSize() {
		return msg.getFetchBlockSize();
	}

	/*
	 * IMAPMessage uses RFC822.SIZE. We use the "size" field from
	 * our BODYSTRUCTURE.
	 */
	public int getSize() throws MessagingException {
		return bs.size;
	}

	/*
	 * Disallow setting flags on nested messages
	 */
	public synchronized void setFlags(final Flags flag, final boolean set) throws MessagingException {
		// Cannot set FLAGS on a nested IMAP message	
		throw new MethodNotSupportedException("Cannot set flags on this nested message");
	}

}
