/*
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.imap;

import java.util.Vector;

import javax.mail.Message;

import com.sun.mail.imap.protocol.MessageSet;
import com.sun.mail.imap.protocol.UIDSet;

public final class Utility {

	// Cannot be initialized
	private Utility() {}

	/**
	 * Run thru the given array of messages, apply the given
	 * Condition on each message and generate sets of contiguous 
	 * sequence-numbers for the successful messages. If a message 
	 * in the given array is found to be expunged, it is ignored.
	 *
	 * ASSERT: Since this method uses and returns message sequence
	 * numbers, you should use this method only when holding the
	 * messageCacheLock.
	 */
	public static MessageSet[] toMessageSet(final Message[] msgs, final Condition cond) {
		Vector v = new Vector(1);

		for (int i = 0; i < msgs.length; i++) {
			IMAPMessage msg = (IMAPMessage) msgs[i];
			if (!msg.isExpunged()) { // expunged message, skip it
				int current = msg.getSequenceNumber();
				// Apply the condition. If it fails, skip it.
				if (cond == null || cond.test(msg)) {
					MessageSet set = new MessageSet();
					set.start = current;

					// Look for contiguous sequence numbers
					for (++i; i < msgs.length; i++) {
						// get next message
						msg = (IMAPMessage) msgs[i];

						if (msg.isExpunged()) // expunged message, skip it
							continue;
						int next = msg.getSequenceNumber();

						// Does this message match our condition ?
						if ((cond != null) && !cond.test(msg))
							continue;

						if (next == current + 1) {
							current = next;
							continue;
						}
						// break in sequence
						// We need to reexamine this message at the top of
						// the outer loop, so decrement 'i' to cancel the
						// outer loop's autoincrement 
						i--;
						break;
					}
					set.end = current;
					v.addElement(set);
				}
			}
		}

		if (v.isEmpty()) // No valid messages
			return null;

		MessageSet[] sets = new MessageSet[v.size()];
		v.copyInto(sets);
		return sets;
	}

	/**
	 * ̃C^tF[X́A<code>toMessageSet()</code> Ŏsׂ test `܂B
	 */
	public static interface Condition {

		public boolean test(IMAPMessage message);

	}

	public static UIDSet[] toUIDSet(Message amessage[]) {
		Vector vector = new Vector(1);
		for (int i = 0; i < amessage.length; i++) {
			IMAPMessage imapmessage = (IMAPMessage) amessage[i];
			if (!imapmessage.isExpunged()) {
				long l = imapmessage.getUID();
				UIDSet uidset = new UIDSet();
				uidset.start = l;
				for (i++; i < amessage.length; i++) {
					IMAPMessage imapmessage1 = (IMAPMessage)amessage[i];
					if (imapmessage1.isExpunged())
						continue;
					long l1 = imapmessage1.getUID();
					if (l1 == l + 1L) {
						l = l1;
						continue;
					}
					i--;
					break;
				}

				uidset.end = l;
				vector.addElement(uidset);
			}
		}

		if (vector.isEmpty()) {
			return null;
		} else {
			UIDSet auidset[] = new UIDSet[vector.size()];
			vector.copyInto(auidset);
			return auidset;
		}
	}

}
