/*
 * Copyright 1997-2003 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.imap.protocol;

import java.io.ByteArrayInputStream;

import com.sun.mail.iap.ByteArray;
import com.sun.mail.iap.ParsingException;


public final class BODY implements Item {

	public static char [] name = { 'B','O','D','Y' };

	public int msgno;
	public ByteArray data;
	public String section;
	public int origin = 0;

	/**
	 * RXgN^łB
	 */
	public BODY(final FetchResponse r) throws ParsingException {
		msgno = r.getNumber();

		r.skipSpaces();

		int b;
		while ((b = r.readByte()) != ']') // skip section
			if (b == 0)
				throw new ParsingException("BODY parse error: missing ``]'' at section end");

		if (r.readByte() == '<') { // origin
			origin = r.readNumber();
			r.skip(1); // skip '>';
		}

		data = r.readByteArray();
	}

	public ByteArray getByteArray() {
		return data;
	}

	public ByteArrayInputStream getByteArrayInputStream() {
		if (data != null)
			return data.toByteArrayInputStream();
		return null;
	}

}
