/*
 * Copyright 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.imap.protocol;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Vector;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeUtility;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Response;


public final class ENVELOPE implements Item {

	// IMAP ږ
	public static char[] name = { 'E','N','V','E','L','O','P','E' };
	public int msgno;

	public Date date = null;
	public String subject;
	public InternetAddress[] from;
	public InternetAddress[] sender;
	public InternetAddress[] replyTo;
	public InternetAddress[] to;
	public InternetAddress[] cc;
	public InternetAddress[] bcc;
	public String inReplyTo;
	public String messageId;

	// tׂ͂Ɏgp܂
	private static MailDateFormat mailDateFormat = new MailDateFormat();

	/**
	 * RXgN^łB
	 */
	public ENVELOPE(final FetchResponse r) throws ParsingException {
		msgno = r.getNumber();

		r.skipSpaces();

		if (r.readByte() != '(')
			throw new ParsingException("ENVELOPE parse error");

		String s = r.readString();
		if (s != null) {
			try {
				date = mailDateFormat.parse(s);
			} catch (Exception pex) {
				// We need to be *very* tolerant about bogus dates (and
				// there's lot of 'em around), so we ignore any 
				// exception (including RunTimeExceptions) and just let 
				// date be null.
			}
		}

		subject = r.readString();
		from = parseAddressList(r);
		sender = parseAddressList(r);
		replyTo = parseAddressList(r);
		to = parseAddressList(r);
		cc = parseAddressList(r);
		bcc = parseAddressList(r);
		inReplyTo = r.readString();
		messageId = r.readString();

		if (r.readByte() != ')')
			throw new ParsingException("ENVELOPE parse error");
	}

	private InternetAddress[] parseAddressList(final Response r) throws ParsingException {
		r.skipSpaces(); // skip leading spaces

		byte b = r.readByte();
		if (b == '(') {
			Vector v = new Vector();

			do {
				v.addElement(new IMAPAddress(r));
			} while (r.peekByte() != ')');

			// skip the terminating ')' at the end of the addresslist
			r.skip(1);

			InternetAddress[] a = new InternetAddress[v.size()];
			v.copyInto(a);
			return a;
		} else if (b == 'N' || b == 'n') { // NIL
			r.skip(2); // skip 'NIL'
			return null;
		} else
			throw new ParsingException("ADDRESS parse error");
	}

}

final class IMAPAddress extends InternetAddress {

	private static final long serialVersionUID = 1L;

	private boolean group = false;
	private InternetAddress grouplist[];
	private String groupname;

	IMAPAddress(final Response r) throws ParsingException {
		r.skipSpaces(); // skip leading spaces

		if (r.readByte() != '(')
			throw new ParsingException("ADDRESS parse error");

		encodedPersonal = r.readString();

		r.readString(); // throw away address_list

// Sugisawa changed. 2005/01/04
String mb = r.readString();
try {
	mb = MimeUtility.decodeText(mb);
} catch (UnsupportedEncodingException e) {}

String host = r.readString();
try {
	host = MimeUtility.decodeText(host);
} catch (UnsupportedEncodingException e) {}

		if (r.readByte() != ')') // skip past terminating ')'
			throw new ParsingException("ADDRESS parse error");

		if (host == null) {
			// it's a group list, start or end
			group = true;
			groupname = mb;
			if (groupname == null)	// end of group list
				return;
			// Accumulate a group list.  The members of the group
			// are accumulated in a Vector and the corresponding string
			// representation of the group is accumulated in a StringBuffer.
			StringBuffer sb = new StringBuffer();
			sb.append(groupname).append(':');
			Vector v = new Vector();
			for (;;) {
				IMAPAddress a = new IMAPAddress(r);
				if (a.group && a.groupname == null)	// reached end of group
					break;
				if (v.size() != 0)	// if not first element, need a comma
					sb.append(',');
				sb.append(a.toString());
				v.addElement(a);
			}
			sb.append(';');
			address = sb.toString();
			grouplist = new IMAPAddress[v.size()];
			v.copyInto(grouplist);
		} else {
			if (mb == null || mb.length() == 0)
				address = host;
			if (host == null || host.length() == 0)
				address = mb;
			else
				address = mb + '@' + host;
		}
	}

	public boolean isGroup() {
		return group;
	}

	public InternetAddress[] getGroup(final boolean strict) throws AddressException {
		if (grouplist == null)
			return null;
		return (InternetAddress[]) grouplist.clone();
	}

}
