/*
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.imap.protocol;

import javax.mail.Flags;

import com.sun.mail.iap.ParsingException;


public final class FLAGS extends Flags implements Item {

	private static final long serialVersionUID = 439049847053756670L;

	// IMAP ږ
	public static char[] name = { 'F','L','A','G','S' };
	public int msgno;

	/**
	 * RXgN^łB
	 */
	public FLAGS(final IMAPResponse r) throws ParsingException {
		msgno = r.getNumber();

		r.skipSpaces();
		String[] flags = r.readSimpleList();
		if (flags != null) { // if not empty flaglist
			for (int i = 0; i < flags.length; i++) {
				String s = flags[i];
				if (s.length() >= 2 && s.charAt(0) == '\\') {
					switch (Character.toUpperCase(s.charAt(1))) {
						case 'S': // \Seen
							add(Flags.Flag.SEEN);
							break;
						case 'R': // \Recent
							add(Flags.Flag.RECENT);
							break;
						case 'D':
							if (s.length() >= 3) {
								char c = s.charAt(2);
								if (c == 'e' || c == 'E') // \Deleted
									add(Flags.Flag.DELETED);
								else if (c == 'r' || c == 'R') // \Draft
									add(Flags.Flag.DRAFT);
							} else
								add(s);	// unknown, treat it as a user flag
							break;
						case 'A': // \Answered
							add(Flags.Flag.ANSWERED);
							break;
						case 'F': // \Flagged
							add(Flags.Flag.FLAGGED);
							break;
						case '*': // \*
							add(Flags.Flag.USER);
							break;
						default:
							add(s);		// unknown, treat it as a user flag
							break;
					}
				} else
					add(s);
			}
		}
	}

}
