/*
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.imap.protocol;

import java.io.IOException;
import java.util.Vector;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Protocol;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;


/**
 * ̃NX IMAP T[oɊ֘A̓Xg[瓾ꂽ\܂B
 */
public final class FetchResponse extends IMAPResponse {

	private Item[] items;

	/**
	 * RXgN^łB
	 */
	public FetchResponse(final Protocol p) throws IOException, ProtocolException {
		super(p);
		parse();
	}

	/**
	 * RXgN^łB
	 */
	public FetchResponse(final IMAPResponse r) throws IOException, ProtocolException {
		super(r);
		parse();
	}

	public int getItemCount() {
		return items.length;
	}

	public Item getItem(final int index) {
		return items[index];
	}

	public Item getItem(final Class c) {
		for (int i = 0; i < items.length; i++) {
			if (c.isInstance(items[i]))
			return items[i];
		}

		return null;
	}

	public static Item getItem(final Response[] r, final int msgno, final Class c) {
		if (r == null)
			return null;

		for (int i = 0; i < r.length; i++) {
			if (r[i] != null && (r[i] instanceof FetchResponse) && ((FetchResponse)r[i]).getNumber() == msgno) {
				FetchResponse f = (FetchResponse) r[i];
				for (int j = 0; j < f.items.length; j++) {
					if (c.isInstance(f.items[j]))
						return f.items[j];
				}
			}
		}

		return null;
	}

	private static final char[] HEADER = { '.','H','E','A','D','E','R' };
	private static final char[] TEXT = { '.','T','E','X','T' };

	private void parse() throws ParsingException {
		skipSpaces();
		if (buffer[index] != '(')
			throw new ParsingException("error in FETCH parsing, missing '(' at index " + index);

		Vector v = new Vector();
		Item i = null;
		do {
			index++; // skip '(', or SPACE

			if (index >= size)
				throw new ParsingException("error in FETCH parsing, ran off end of buffer, size " + size);

			switch (buffer[index]) {
				case 'E': 
					if (match(ENVELOPE.name)) {
						index += ENVELOPE.name.length; // skip "ENVELOPE"
						i = new ENVELOPE(this);
					}
					break;
				case 'F': 
					if (match(FLAGS.name)) {
						index += FLAGS.name.length; // skip "FLAGS"
						i = new FLAGS(this);
					}
					break;
				case 'I': 
					if (match(INTERNALDATE.name)) {
						index += INTERNALDATE.name.length; // skip "INTERNALDATE"
						i = new INTERNALDATE(this);
					}
					break;
				case 'B': 
					if (match(BODY.name)) {
						if (buffer[index+4] == '[') {
							index += BODY.name.length; // skip "BODY"
							i = new BODY(this);
						} else {
							if (match(BODYSTRUCTURE.name))
								index += BODYSTRUCTURE.name.length;
								// skip "BODYSTRUCTURE"
							else
								index += BODY.name.length; // skip "BODY"
							i = new BODYSTRUCTURE(this);
						}
					}
					break;
				case 'R':
					if (match(RFC822SIZE.name)) {
						index += RFC822SIZE.name.length; // skip "RFC822.SIZE"
						i = new RFC822SIZE(this);
					} else {
						if (match(RFC822DATA.name)) {
							index += RFC822DATA.name.length;
							if (match(HEADER))
								index += HEADER.length; // skip ".HEADER"
							else if (match(TEXT))
								index += TEXT.length; // skip ".TEXT"
							i = new RFC822DATA(this);
						}
					}
					break;
				case 'U': 
					if (match(UID.name)) {
						index += UID.name.length;
						i = new UID(this);
					}
					break;
				default: 
			}
			if (i != null)
				v.addElement(i);
		} while (buffer[index] != ')');

		index++; // skip ')'
		items = new Item[v.size()];
		v.copyInto(items);
	}

	/*
	 * itemName is the name of the IMAP item to compare against.
	 * NOTE that itemName *must* be all uppercase.
	 */
	private boolean match(final char[] itemName) {
		int len = itemName.length;
		for (int i = 0, j = index; i < len;)
			// IMAP tokens are case-insensitive. We store itemNames in
			// uppercase, so convert operand to uppercase before comparing.
			if (Character.toUpperCase((char)buffer[j++]) != itemName[i++])
				return false;
		return true;
	}

}
