/*
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.imap.protocol;

import java.io.IOException;
import java.util.Vector;

import com.sun.mail.iap.Protocol;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.util.ASCIIUtility;


/**
 * ̃NX IMAP T[oɊ֘A̓Xg[瓾ꂽ\܂B
 */
public class IMAPResponse extends Response {

	private String key;
	private int number;

	/**
	 * RXgN^łB
	 */
	public IMAPResponse(final Protocol c) throws IOException, ProtocolException {
		super(c);

		// continue parsing if this is an untagged response
		if (isUnTagged() && !isOK() && !isNO() && !isBAD() && !isBYE()) {
			key = readAtom();

			// Is this response of the form "* <number> <command>"
			try {
				number = Integer.parseInt(key);
				key = readAtom();
			} catch (NumberFormatException ne) {}
		}
	}

	/**
	 * Rs[p̃RXgN^łB
	 */
	public IMAPResponse(final IMAPResponse r) {
		super(r);
		key = r.key;
		number = r.number;
	}

	/**
	 * Read a list of space-separated "flag_extension" sequences and 
	 * return the list as a array of Strings. An empty list is returned
	 * as null.  This is an IMAP-ism, and perhaps this method should 
	 * moved into the IMAP layer.
	 */
	public final String[] readSimpleList() {
		skipSpaces();

		if (buffer[index] != '(') // not what we expected
			return null;
		index++; // skip '('

		Vector v = new Vector();
		int start;
		for (start = index; buffer[index] != ')'; index++) {
			if (buffer[index] == ' ') { // got one item
				v.addElement(ASCIIUtility.toString(buffer, start, index));
				start = index+1; // index gets incremented at the top
			}
		}
		if (index > start) // get the last item
			v.addElement(ASCIIUtility.toString(buffer, start, index));
		index++; // skip ')'

		int size = v.size();
		if (size > 0) {
			String[] s = new String[size];
			v.copyInto(s);
			return s;
		}
		// ̃Xg
		return null;
	}

	public final String getKey() {
		return key;
	}

	public final boolean keyEquals(final String k) {
		return (key != null && key.equalsIgnoreCase(k));
	}

	public final int getNumber() {
		return number;
	}

	public static final IMAPResponse readResponse(final Protocol p) throws IOException, ProtocolException {
		IMAPResponse r = new IMAPResponse(p);
		if (r.keyEquals("FETCH"))
			r = new FetchResponse(r);
		return r;
	}

}
