/*
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.imap.protocol;

import java.io.UnsupportedEncodingException;
import java.util.Vector;

import jp.sourceforge.livez.mail.util.WindowsEUCJP;
import jp.sourceforge.livez.mail.util.WindowsJIS;

public final class ListInfo {

	public String name = null;
	public char separator = '/';
	public boolean hasInferiors = true;
	public boolean canOpen = true;
	public int changeState = INDETERMINATE;
	public String attrs[];

	public static final int CHANGED			= 1;
	public static final int UNCHANGED		= 2;
	public static final int INDETERMINATE	= 3;

	/**
	 * RXgN^łB
	 */
	public ListInfo(final IMAPResponse r) /* throws ParsingException */ {
		String[] s = r.readSimpleList();
		Vector vector = new Vector();

		if (s != null) {
			// non-empty attribute list
			for (int i = 0; i < s.length; i++) {
				if (s[i].equalsIgnoreCase("\\Marked"))
					changeState = CHANGED;
				else if (s[i].equalsIgnoreCase("\\Unmarked"))
					changeState = UNCHANGED;
				else if (s[i].equalsIgnoreCase("\\Noselect"))
					canOpen = false;
				else if (s[i].equalsIgnoreCase("\\Noinferiors"))
					hasInferiors = false;
				vector.addElement(s[i]);
			}
		}
		attrs = new String[vector.size()];
		vector.copyInto(attrs);

		r.skipSpaces();
		if (r.readByte() == '"') {
			if ((separator = (char) r.readByte()) == '\\')
				// escaped separator character
				separator = (char) r.readByte();	
			r.skip(1); // skip <">
		} else // NIL
			r.skip(2);

		r.skipSpaces();
		name = r.readAtomString();
		// decode the name (using RFC2060's modified UTF7)
		name = BASE64MailboxDecoder.decode(name);
	}

/**
 * RXgN^łB
 * 
 * @since Sugisawa added. 2004/6/30
 */
public ListInfo(final IMAPResponse r, final String charset) /* throws ParsingException */ {
	String[] s = r.readSimpleList();

	if (s != null) {
		// non-empty attribute list
		for (int i = 0; i < s.length; i++) {
			if (s[i].equalsIgnoreCase("\\Marked"))
				changeState = CHANGED;
			else if (s[i].equalsIgnoreCase("\\Unmarked"))
				changeState = UNCHANGED;
			else if (s[i].equalsIgnoreCase("\\Noselect"))
				canOpen = false;
			else if (s[i].equalsIgnoreCase("\\Noinferiors"))
				hasInferiors = false;
		}
	}

	r.skipSpaces();
	if (r.readByte() == '"') {
		if ((separator = (char) r.readByte()) == '\\')
			// escaped separator character
			separator = (char) r.readByte();	
		r.skip(1); // skip <">
	} else // NIL
		r.skip(2);

	r.skipSpaces();

	String work = r.readAtomString();
	byte[] bytes = new byte[work.length()];
	for (int index = 0; index < bytes.length; index++) {
		bytes[index] = (byte) work.charAt(index);
	}

	try {
		if (charset.equalsIgnoreCase("ISO-2022-JP"))
			name = WindowsJIS.decode(bytes);
		else if (charset.equalsIgnoreCase("Shift_JIS"))
			name = new String(bytes, "Windows-31J");
		else if (charset.equalsIgnoreCase("euc-jp"))
			name = WindowsEUCJP.decode(bytes);
		else
			name = new String(bytes, charset);
	} catch (UnsupportedEncodingException e) {
		name = new String(bytes);
	}
}

}
