/*
 * Copyright 1997-2003 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.mail.imap.protocol;

import javax.mail.Flags;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Response;


public final class MailboxInfo {

	public Flags availableFlags = null;
	public Flags permanentFlags = null;
	public int total = -1;
	public int recent = -1;
	public int first = -1;
	public int uidvalidity = -1;
	public int uidnext = -1;
	public int mode;

	/**
	 * RXgN^łB
	 */
	public MailboxInfo(final Response[] r) throws ParsingException {
		for (int i = 0; i < r.length; i++)
			if (r[i] != null && (r[i] instanceof IMAPResponse)) {
				IMAPResponse ir = (IMAPResponse) r[i];

				if (ir.keyEquals("EXISTS")) {
					total = ir.getNumber();
					r[i] = null;	// ̃X|X폜܂
				} else if (ir.keyEquals("RECENT")) {
					recent = ir.getNumber();
					r[i] = null;	// ̃X|X폜܂
				} else if (ir.keyEquals("FLAGS")) {
					availableFlags = new FLAGS(ir);
					r[i] = null;	// ̃X|X폜܂
				} else if (ir.isUnTagged() && ir.isOK()) {
					/* should be one of:
					 * OK [UNSEEN 12]
					 * OK [UIDVALIDITY 3857529045]
					 * OK [PERMANENTFLAGS (\Deleted)]
					 * OK [UIDNEXT 44]
					 */
					ir.skipSpaces();

					if (ir.readByte() != '[') {	// H
						ir.reset();
					} else {
						boolean handled = true;
						String s = ir.readAtom();
						if (s.equalsIgnoreCase("UNSEEN"))
							first = ir.readNumber();
						else if (s.equalsIgnoreCase("UIDVALIDITY"))
							uidvalidity = ir.readNumber();
						else if (s.equalsIgnoreCase("PERMANENTFLAGS"))
							permanentFlags = new FLAGS(ir);
						else if (s.equalsIgnoreCase("UIDNEXT"))	// nothing to do
							uidnext = ir.readNumber();
						else
							handled = false;	// possibly an ALERT

						if (handled)
							r[i] = null;	// ̃X|X폜܂
						else
							ir.reset();	// so ALERT can be read
					}
				}
			}

		/*
		 * The PERMANENTFLAGS response code is optional, and if
		 * not present implies that all flags in the required FLAGS
		 * response can be changed permanently.
		 */
		if (permanentFlags == null) {
			if (availableFlags != null)
				permanentFlags = new Flags(availableFlags);
			else
				permanentFlags = new Flags();
		}
	}

}
